/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers

import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirDynamicUnsupportedChecker
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirResolvedTypeRefChecker
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.TypeCheckers

object WasmBaseTypeCheckers : TypeCheckers() {
    override val resolvedTypeRefCheckers: Set<FirResolvedTypeRefChecker> = setOf(
        FirDynamicUnsupportedChecker,
    )
}
