// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.pom;

import ksp.com.intellij.ide.IconProvider;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import javax.swing.*;

public abstract class PomIconProvider extends IconProvider {
  @Override
  public Icon getIcon(@NotNull PsiElement element, int flags) {
    if (element instanceof PomTargetPsiElement) {
      return getIcon(((PomTargetPsiElement)element).getTarget(), flags);
    }
    return null;
  }

  public abstract @Nullable Icon getIcon(@NotNull PomTarget target, int flags);
}
