// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.pom.tree;

import ksp.com.intellij.openapi.components.Service;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.pom.PomModelAspect;
import ksp.com.intellij.pom.event.PomModelEvent;
import ksp.org.jetbrains.annotations.NotNull;

@Service(Service.Level.PROJECT)
public final class TreeAspect implements PomModelAspect {
  public static TreeAspect getInstance(@NotNull Project project) {
    return project.getService(TreeAspect.class);
  }

  @Override
  public void update(@NotNull PomModelEvent event) {}
}
