// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

package ksp.com.intellij.psi.impl.smartPointers;

import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.util.Segment;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

abstract class SmartPointerElementInfo {
  @Nullable
  Document getDocumentToSynchronize() {
    return null;
  }

  void fastenBelt(@NotNull SmartPointerManagerImpl manager) {
  }

  abstract @Nullable PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager);

  abstract @Nullable PsiFile restoreFile(@NotNull SmartPointerManagerImpl manager);

  abstract int elementHashCode(); // must be immutable
  abstract boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager);

  abstract VirtualFile getVirtualFile();

  abstract @Nullable Segment getRange(@NotNull SmartPointerManagerImpl manager);

  abstract @Nullable Segment getPsiRange(@NotNull SmartPointerManagerImpl manager);

  void cleanup() {
  }
}
