/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ksp.com.intellij.psi.infos;

import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.org.jetbrains.annotations.NotNull;

public class ClassCandidateInfo extends CandidateInfo {
  public ClassCandidateInfo(@NotNull PsiElement candidate,
                            @NotNull PsiSubstitutor substitutor,
                            boolean accessProblem,
                            PsiElement currFileContext) {
    super(candidate, substitutor, accessProblem, false, currFileContext);
  }

  public ClassCandidateInfo(@NotNull PsiElement candidate, @NotNull PsiSubstitutor substitutor) {
    super(candidate, substitutor, false, false);
  }

  @NotNull
  @Override
  public PsiClass getElement() {
    return (PsiClass)super.getElement();
  }
}