// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

package ksp.com.intellij.util;

import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.util.CachedValueProvider;
import ksp.com.intellij.psi.util.ParameterizedCachedValue;
import ksp.com.intellij.psi.util.ParameterizedCachedValueProvider;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import java.lang.ref.SoftReference;

import static com.intellij.reference.SoftReference.dereference;

public final class ParameterizedCachedValueImpl<T,P> extends CachedValueBase<T> implements ParameterizedCachedValue<T,P> {
  private final @NotNull Project myProject;
  private final ParameterizedCachedValueProvider<T,P> myProvider;
  private volatile SoftReference<Data<T>> myData;

  ParameterizedCachedValueImpl(@NotNull Project project,
                               @NotNull ParameterizedCachedValueProvider<T, P> provider,
                               boolean trackValue) {
    super(trackValue);
    myProject = project;
    myProvider = provider;
  }

  @Override
  protected @Nullable Data<T> getRawData() {
    return dereference(myData);
  }

  @Override
  protected void setData(@Nullable Data<T> data) {
    myData = data == null ? null : new SoftReference<>(data);
  }

  @Override
  public T getValue(P param) {
    return getValueWithLock(param);
  }

  @Override
  public boolean isFromMyProject(@NotNull Project project) {
    return myProject == project;
  }

  @Override
  public @NotNull ParameterizedCachedValueProvider<T,P> getValueProvider() {
    return myProvider;
  }

  @Override
  protected <X> CachedValueProvider.Result<T> doCompute(X param) {
    return myProvider.compute((P)param);
  }
}
