/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.resolve

import ksp.org.jetbrains.kotlin.container.DefaultImplementation
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor

@DefaultImplementation(PlatformAnnotationFeaturesSupport.Default::class)
interface PlatformAnnotationFeaturesSupport {
    fun isRepeatableAnnotationClass(descriptor: ClassDescriptor): Boolean

    object Default : PlatformAnnotationFeaturesSupport {
        override fun isRepeatableAnnotationClass(descriptor: ClassDescriptor): Boolean = false
    }
}
