/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.resolve.jvm.checkers

import ksp.org.jetbrains.kotlin.config.JvmAnalysisFlags
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor
import ksp.org.jetbrains.kotlin.fileClasses.JvmFileClassUtil
import ksp.org.jetbrains.kotlin.psi.KtDeclaration
import ksp.org.jetbrains.kotlin.resolve.BindingContext
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm

object JvmMultifileClassStateChecker : DeclarationChecker {
    override fun check(declaration: KtDeclaration, descriptor: DeclarationDescriptor, context: DeclarationCheckerContext) {
        if (descriptor !is PropertyDescriptor ||
            !DescriptorUtils.isTopLevelDeclaration(descriptor) ||
            descriptor.isExpect ||
            descriptor.isConst) return

        if (!context.languageVersionSettings.getFlag(JvmAnalysisFlags.inheritMultifileParts)) return

        if (!JvmFileClassUtil.getFileClassInfoNoResolve(declaration.containingKtFile).withJvmMultifileClass) return

        if (descriptor.isDelegated ||
            context.trace.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor) == true) {
            context.trace.report(ErrorsJvm.STATE_IN_MULTIFILE_CLASS.on(declaration))
        }
    }
}
