// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.ide;

import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.util.Iconable;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import javax.swing.*;

public interface IconLayerProvider {
  ExtensionPointName<IconLayerProvider> EP_NAME = new ExtensionPointName<>("com.intellij.iconLayerProvider");

  @Nullable
  Icon getLayerIcon(@NotNull Iconable element, boolean isLocked);

  @NotNull
  String getLayerDescription();
}
