// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.navigation;

import ksp.com.intellij.model.Symbol;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.platform.backend.navigation.NavigationTarget;
import ksp.com.intellij.platform.backend.presentation.TargetPresentation;
import ksp.com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NotNull;

import java.util.Collection;

/**
 * This is an entry point to obtain {@link NavigationTarget}s of a {@link Symbol}.
 * <p/>
 * Implement {@link NavigatableSymbol} in the {@link Symbol}
 * or implement a {@link SymbolNavigationProvider} extension
 * to customize navigation targets of the {@link Symbol}.
 */
@ApiStatus.Experimental
public interface SymbolNavigationService {

  static @NotNull SymbolNavigationService getInstance() {
    return ApplicationManager.getApplication().getService(SymbolNavigationService.class);
  }

  @NotNull
  Collection<? extends NavigationTarget> getNavigationTargets(@NotNull Project project, @NotNull Symbol symbol);

  @Contract("_ -> new")
  @NotNull NavigationTarget psiFileNavigationTarget(@NotNull PsiFile file);

  /**
   * This method exists for compatibility. Use with care.
   *
   * @return a target instance which delegates its implementation to older PSI-based APIs
   */
  @Contract("_ -> new")
  @NotNull NavigationTarget psiElementNavigationTarget(@NotNull PsiElement element);

  /**
   * Please use {@link TargetPresentation#builder(String)}
   */
  @ApiStatus.Internal
  @NotNull TargetPresentationBuilder presentationBuilder(@Nls @NotNull String presentableText);
}
