// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.application

import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.openapi.util.ThrowableComputable
import ksp.org.jetbrains.annotations.ApiStatus.Internal

@Internal
interface ReadWriteActionSupport {

  fun smartModeConstraint(project: Project): ReadConstraint

  fun committedDocumentsConstraint(project: Project): ReadConstraint

  suspend fun <X> executeReadAction(
    constraints: List<ReadConstraint>,
    undispatched: Boolean = false,
    blocking: Boolean = false,
    action: () -> X,
  ): X

  fun <X, E : Throwable> computeCancellable(action: ThrowableComputable<X, E>): X

  suspend fun <X> executeReadAndWriteAction(
    constraints: Array<out ReadConstraint>,
    action: ReadAndWriteScope.() -> ReadResult<X>,
  ): X
}
