// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.fileTypes;

import ksp.com.intellij.openapi.extensions.RequiredElement;
import ksp.com.intellij.serviceContainer.BaseKeyedLazyInstance;
import ksp.com.intellij.util.KeyedLazyInstance;
import ksp.com.intellij.util.xmlb.annotations.Attribute;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

public final class FileTypeExtensionPoint<T> extends BaseKeyedLazyInstance<T> implements KeyedLazyInstance<T> {
  // these must be public for scrambling compatibility
  @Attribute("filetype")
  @RequiredElement
  public String filetype;

  @Attribute("implementationClass")
  @RequiredElement
  public String implementationClass;

  @SuppressWarnings("unused")
  FileTypeExtensionPoint() {
  }

  @TestOnly
  public FileTypeExtensionPoint(@NotNull String filetype, @NotNull T instance) {
    super(instance);

    this.filetype = filetype;
    implementationClass = instance.getClass().getName();
  }

  @Override
  protected @Nullable String getImplementationClassName() {
    return implementationClass;
  }

  @Override
  public @NotNull String getKey() {
    return filetype;
  }
}