// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.platform.backend.navigation

import ksp.com.intellij.openapi.application.ApplicationManager
import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.openapi.util.TextRange
import ksp.com.intellij.openapi.vfs.VirtualFile
import ksp.com.intellij.pom.Navigatable
import ksp.com.intellij.psi.PsiDirectory
import ksp.com.intellij.psi.PsiElement
import ksp.com.intellij.util.concurrency.annotations.RequiresBackgroundThread
import ksp.com.intellij.util.concurrency.annotations.RequiresReadLock
import ksp.org.jetbrains.annotations.ApiStatus.Internal

@Internal
interface NavigationRequests {

  companion object {

    @JvmStatic
    fun getInstance(): NavigationRequests = ApplicationManager.getApplication().getService(NavigationRequests::class.java)
  }

  @RequiresReadLock
  @RequiresBackgroundThread
  fun sourceNavigationRequest(project: Project, file: VirtualFile, offset: Int, elementRange: TextRange?): NavigationRequest?

  @RequiresReadLock
  @RequiresBackgroundThread
  fun directoryNavigationRequest(directory: PsiDirectory): NavigationRequest?

  /**
   * Adapted version of [com.intellij.ide.util.EditSourceUtil.getDescriptor].
   */
  @Internal
  @Deprecated("Do not call this function by hand")
  @RequiresReadLock
  @RequiresBackgroundThread
  fun psiNavigationRequest(element: PsiElement): NavigationRequest?

  /**
   * @return a request to execute an [arbitrary code][Navigatable.navigate],
   * or `null` if the navigation is not possible for any reason
   */
  @Internal
  @Deprecated("Don't call this function directly")
  @RequiresReadLock
  @RequiresBackgroundThread
  fun rawNavigationRequest(navigatable: Navigatable): NavigationRequest?
}
