// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.platform.diagnostic.telemetry.helpers;

import ksp.com.intellij.openapi.util.ThrowableNotNullFunction;
import ksp.com.intellij.util.ThrowableConsumer;
import ksp.io.opentelemetry.api.trace.Span;
import ksp.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import ksp.org.jetbrains.annotations.NotNull;


@SuppressWarnings("RedundantThrows") //Kotlin doesn't support checked exception, so we need to create inter-op java / kotlin
public final class TraceUtil {

  @NotNull
  public static <T, E extends Throwable> T computeWithSpanThrows(@NotNull Tracer tracer,
                                                                 @NotNull String spanName,
                                                                 @NotNull ThrowableNotNullFunction<Span, T, E> operation) throws E {
    return TraceKt.computeWithSpanIgnoreThrows(tracer, spanName, operation);
  }

  public static <E extends Throwable> void runWithSpanThrows(@NotNull Tracer tracer,
                                                             @NotNull String spanName,
                                                             @NotNull ThrowableConsumer<Span, E> operation) throws E {
    TraceKt.runWithSpanIgnoreThrows(tracer, spanName, operation);
  }

  public static <E extends Throwable> void runWithSpanThrows(@NotNull Tracer tracer,
                                                             @NotNull Context context,
                                                             @NotNull String spanName,
                                                             @NotNull ThrowableConsumer<Span, E> operation) throws E {
    try(Scope ignored = context.makeCurrent()) {
      TraceKt.runWithSpanIgnoreThrows(tracer, spanName, operation);
    }
  }
}
