// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.pom;

import ksp.com.intellij.pom.event.PomModelEvent;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;

public interface PomTransaction {
  @NotNull
  PomModelEvent getAccumulatedEvent();

  void run() throws IncorrectOperationException;

  @NotNull
  PsiElement getChangeScope();

}
