// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi;

import ksp.com.intellij.lang.jvm.JvmMethod;
import ksp.com.intellij.lang.jvm.JvmTypeDeclaration;
import ksp.com.intellij.lang.jvm.JvmTypeParameter;
import ksp.com.intellij.lang.jvm.types.JvmSubstitutor;
import ksp.com.intellij.lang.jvm.types.JvmType;
import ksp.com.intellij.openapi.project.Project;
import ksp.org.jetbrains.annotations.ApiStatus.Experimental;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Experimental
public interface JvmPsiConversionHelper {
  @NotNull
  static JvmPsiConversionHelper getInstance(@NotNull Project project) {
    return project.getService(JvmPsiConversionHelper.class);
  }

  @Nullable
  PsiClass convertTypeDeclaration(@Nullable JvmTypeDeclaration typeDeclaration);

  @NotNull
  PsiTypeParameter convertTypeParameter(@NotNull JvmTypeParameter typeParameter);

  @NotNull
  PsiType convertType(@NotNull JvmType type);

  @NotNull
  PsiSubstitutor convertSubstitutor(@NotNull JvmSubstitutor substitutor);

  @NotNull
  PsiMethod convertMethod(@NotNull JvmMethod method);
}
