/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ksp.com.intellij.psi;

import ksp.com.intellij.lang.jvm.JvmTypeParameter;
import ksp.com.intellij.lang.jvm.types.JvmSubstitutor;
import ksp.com.intellij.lang.jvm.types.JvmType;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.annotations.ApiStatus.Experimental;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import java.util.Collection;

@Experimental
public class PsiJvmSubstitutor implements JvmSubstitutor {

  private final @NotNull Project myProject;
  private final @NotNull PsiSubstitutor mySubstitutor;

  public PsiJvmSubstitutor(@NotNull Project project, @NotNull PsiSubstitutor substitutor) {
    myProject = project;
    mySubstitutor = substitutor;
  }

  @NotNull
  @Override
  public Collection<JvmTypeParameter> getTypeParameters() {
    return new SmartList<>(mySubstitutor.getSubstitutionMap().keySet());
  }

  @Nullable
  @Override
  public JvmType substitute(@NotNull JvmTypeParameter typeParameter) {
    JvmPsiConversionHelper helper = JvmPsiConversionHelper.getInstance(myProject);
    PsiTypeParameter psiTypeParameter = helper.convertTypeParameter(typeParameter);
    return mySubstitutor.substitute(psiTypeParameter);
  }

  @NotNull
  public PsiSubstitutor getPsiSubstitutor() {
    return mySubstitutor;
  }
}
