// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi;

import ksp.com.intellij.model.psi.PsiExternalReferenceHost;
import ksp.org.jetbrains.annotations.Nullable;

public interface PsiLiteralValue extends PsiElement, PsiExternalReferenceHost {
  /**
   * Returns the value of the literal expression (an {@link Integer} for an integer constant, a {@link String}
   * for a string literal, and so on).
   *
   * @return the value of the expression, or null if the parsing of the literal failed.
   */
  @Nullable
  Object getValue();
}
