// Copyright 2000-2021 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.java.stubs;

import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.PsiClass;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.Nullable;

public interface PsiClassStub<T extends PsiClass> extends PsiMemberStub<T> {
  @Nullable String getQualifiedName();

  @Nullable String getBaseClassReferenceText();

  boolean isInterface();

  boolean isEnum();

  default boolean isRecord() {
    return false;
  }

  default boolean isImplicit() {
    return false;
  }

  boolean isEnumConstantInitializer();

  boolean isAnonymous();

  boolean isAnonymousInQualifiedNew();

  boolean isAnnotationType();

  @Nullable String getSourceFileName();

  /** @deprecated use {@link PsiJavaFileStub#getLanguageLevel()}; do not override */
  @Deprecated
  @ApiStatus.ScheduledForRemoval
  default LanguageLevel getLanguageLevel() { return null; }
}
