// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.source.tree.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiLoopStatement;
import ksp.com.intellij.psi.impl.source.tree.CompositePsiElement;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;

abstract class PsiLoopStatementImpl extends CompositePsiElement implements PsiLoopStatement {
  protected PsiLoopStatementImpl(IElementType type) {
    super(type);
  }

  @Override
  public void deleteChildInternal(@NotNull ASTNode child) {
    if (child == getBody()) {
      replaceChildInternal(child, (TreeElement)JavaPsiFacade.getElementFactory(getProject()).createStatementFromText("{}", null));
    } else {
      super.deleteChildInternal(child);
    }
  }
}
