// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.serialization;

import ksp.com.intellij.util.xmlb.Accessor;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface MutableAccessor extends Accessor {
  void set(@NotNull Object host, @Nullable Object value);

  void setBoolean(@NotNull Object host, boolean value);

  void setInt(@NotNull Object host, int value);

  void setShort(@NotNull Object host, short value);

  void setLong(@NotNull Object host, long value);

  void setDouble(@NotNull Object host, double value);

  void setFloat(@NotNull Object host, float value);
}
