/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.checkers.diagnostics

import ksp.com.intellij.openapi.util.TextRange
import ksp.com.intellij.psi.PsiElement
import ksp.com.intellij.psi.PsiErrorElement
import ksp.com.intellij.psi.PsiFile
import ksp.org.jetbrains.kotlin.checkers.diagnostics.factories.SyntaxErrorDiagnosticFactory
import ksp.org.jetbrains.kotlin.diagnostics.Diagnostic
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory
import ksp.org.jetbrains.kotlin.diagnostics.Severity
import ksp.org.jetbrains.kotlin.psi.KtElement

class DebugInfoDiagnostic(element: KtElement, factory: DiagnosticFactory<*>) : AbstractDiagnosticForTests(element, factory)
class SyntaxErrorDiagnostic(errorElement: PsiErrorElement) : AbstractDiagnosticForTests(
    errorElement,
    SyntaxErrorDiagnosticFactory.INSTANCE
)

open class AbstractDiagnosticForTests(override val psiElement: PsiElement, override val factory: DiagnosticFactory<*>) : Diagnostic {
    override val severity: Severity
        get() = Severity.ERROR

    override val textRanges: List<TextRange>
        get() = listOf(psiElement.textRange)

    override val psiFile: PsiFile
        get() = psiElement.containingFile

    override val isValid: Boolean
        get() = true
}