/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir

import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol
import ksp.org.jetbrains.kotlin.mpp.RegularClassSymbolMarker
import ksp.org.jetbrains.kotlin.name.Name
import ksp.org.jetbrains.kotlin.resolve.calls.mpp.ExpectActualMatchingContext

interface FirExpectActualMatchingContext : ExpectActualMatchingContext<FirBasedSymbol<*>> {
    fun FirClassSymbol<*>.getConstructors(
        scopeSession: ScopeSession,
        session: FirSession = moduleData.session,
    ): Collection<FirConstructorSymbol>

    val expectScopeSession: ScopeSession
    override fun RegularClassSymbolMarker.getCallablesForExpectClass(name: Name): List<FirCallableSymbol<*>>
    fun RegularClassSymbolMarker.getStaticCallablesForExpectClass(name: Name): List<FirCallableSymbol<*>>
}

interface FirExpectActualMatchingContextFactory : FirSessionComponent {
    fun create(
        actualSession: FirSession,
        actualScopeSession: ScopeSession,
        allowedWritingMemberExpectForActualMapping: Boolean = false,
    ): FirExpectActualMatchingContext
}

val FirSession.expectActualMatchingContextFactory: FirExpectActualMatchingContextFactory by FirSession.sessionComponentAccessor()