/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.diagnostics.reportOn
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors
import ksp.org.jetbrains.kotlin.fir.declarations.annotationPlatformSupport
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty
import ksp.org.jetbrains.kotlin.fir.declarations.getAnnotationByClassIds

object FirVolatileAnnotationChecker : FirPropertyChecker(MppCheckerKind.Platform) {
    context(context: CheckerContext, reporter: DiagnosticReporter)
    override fun check(declaration: FirProperty) {
        val volatileAnnotations = context.session.annotationPlatformSupport.volatileAnnotations
        val fieldAnnotation = declaration.backingField?.annotations?.getAnnotationByClassIds(volatileAnnotations, context.session)
            ?: return

        if (!declaration.isVar) {
            reporter.reportOn(fieldAnnotation.source, FirErrors.VOLATILE_ON_VALUE)
        }

        if (declaration.delegateFieldSymbol != null) {
            reporter.reportOn(fieldAnnotation.source, FirErrors.VOLATILE_ON_DELEGATE)
        }
    }
}
