/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.diagnostics.reportOn
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.resolve.getContainingClassSymbol
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors
import ksp.org.jetbrains.kotlin.fir.declarations.utils.isInner
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier
import ksp.org.jetbrains.kotlin.fir.references.toResolvedConstructorSymbol

object FirGenericQualifierOnConstructorCallChecker : FirFunctionCallChecker(MppCheckerKind.Common) {
    context(context: CheckerContext, reporter: DiagnosticReporter)
    override fun check(expression: FirFunctionCall) {
        val resolvedQualifier = expression.explicitReceiver as? FirResolvedQualifier ?: return
        if (resolvedQualifier.typeArguments.isEmpty()) return
        val constructorSymbol = expression.calleeReference.toResolvedConstructorSymbol() ?: return
        if (constructorSymbol.getContainingClassSymbol()?.isInner != false) return

        reporter.reportOn(
            resolvedQualifier.source,
            FirErrors.GENERIC_QUALIFIER_ON_CONSTRUCTOR_CALL
        )
    }
}