/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.collectors

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.MutableCheckerContext
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculatorForFullBodyResolve

class CliDiagnosticsCollector(
    session: FirSession,
    scopeSession: ScopeSession,
    createComponents: (DiagnosticReporter) -> DiagnosticCollectorComponents,
) : AbstractDiagnosticCollector(session, scopeSession, createComponents) {
    override fun createVisitor(components: DiagnosticCollectorComponents): CheckerRunningDiagnosticCollectorVisitor {
        return CheckerRunningDiagnosticCollectorVisitor(
            MutableCheckerContext(this, ReturnTypeCalculatorForFullBodyResolve.Default),
            components
        )
    }
}

