/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.backend

import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.declarations.FirScript
import ksp.org.jetbrains.kotlin.fir.extensions.FirExtension
import ksp.org.jetbrains.kotlin.fir.extensions.FirExtensionPointName
import ksp.org.jetbrains.kotlin.fir.extensions.FirExtensionService
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol
import ksp.org.jetbrains.kotlin.ir.declarations.IrScript
import ksp.org.jetbrains.kotlin.ir.symbols.IrScriptSymbol
import kotlin.reflect.KClass

abstract class Fir2IrScriptConfiguratorExtension(
    session: FirSession,
) : FirExtension(session) {
    companion object {
        val NAME: FirExtensionPointName = FirExtensionPointName("Fir2IrScriptConversion")
    }

    final override val name: FirExtensionPointName
        get() = NAME

    final override val extensionType: KClass<out FirExtension> = Fir2IrScriptConfiguratorExtension::class

    fun interface Factory : FirExtension.Factory<Fir2IrScriptConfiguratorExtension>

    abstract fun IrScript.configure(script: FirScript, getIrScriptByFirSymbol: (FirScriptSymbol) -> IrScriptSymbol?)
}

val FirExtensionService.fir2IrScriptConfigurators: List<Fir2IrScriptConfiguratorExtension> by FirExtensionService.registeredExtensions()
