/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.builder

import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryToRendererMap
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderers.OPTIONAL_COLON_TO_STRING
import ksp.org.jetbrains.kotlin.diagnostics.rendering.BaseDiagnosticRendererFactory

object FirSyntaxErrorsDefaultMessages : BaseDiagnosticRendererFactory() {
    override val MAP: KtDiagnosticFactoryToRendererMap by KtDiagnosticFactoryToRendererMap("FIR") { map ->
        map.put(FirSyntaxErrors.SYNTAX, "Syntax error{0}.", OPTIONAL_COLON_TO_STRING)
    }
}
