/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/fir/tree/tree-generator/Readme.md.
// DO NOT MODIFY IT MANUALLY.

@file:Suppress("DuplicatedCode", "unused")

package ksp.org.jetbrains.kotlin.fir.expressions.builder

import kotlin.contracts.*
import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget
import ksp.org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder
import ksp.org.jetbrains.kotlin.fir.builder.FirBuilderDsl
import ksp.org.jetbrains.kotlin.fir.builder.toMutableOrEmpty
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationArgumentMapping
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirAnnotationImpl
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef

@FirBuilderDsl
class FirAnnotationBuilder : FirAnnotationContainerBuilder, FirExpressionBuilder {
    override var source: KtSourceElement? = null
    var useSiteTarget: AnnotationUseSiteTarget? = null
    lateinit var annotationTypeRef: FirTypeRef
    lateinit var argumentMapping: FirAnnotationArgumentMapping
    val typeArguments: MutableList<FirTypeProjection> = mutableListOf()

    override fun build(): FirAnnotation {
        return FirAnnotationImpl(
            source,
            useSiteTarget,
            annotationTypeRef,
            argumentMapping,
            typeArguments.toMutableOrEmpty(),
        )
    }


    @Deprecated("Modification of 'coneTypeOrNull' has no impact for FirAnnotationBuilder", level = DeprecationLevel.HIDDEN)
    override var coneTypeOrNull: ConeKotlinType?
        get() = throw IllegalStateException()
        set(_) {
            throw IllegalStateException()
        }

    @Deprecated("Modification of 'annotations' has no impact for FirAnnotationBuilder", level = DeprecationLevel.HIDDEN)
    override val annotations: MutableList<FirAnnotation> = mutableListOf()
}

@OptIn(ExperimentalContracts::class)
inline fun buildAnnotation(init: FirAnnotationBuilder.() -> Unit): FirAnnotation {
    contract {
        callsInPlace(init, InvocationKind.EXACTLY_ONCE)
    }
    return FirAnnotationBuilder().apply(init).build()
}

@OptIn(ExperimentalContracts::class)
inline fun buildAnnotationCopy(original: FirAnnotation, init: FirAnnotationBuilder.() -> Unit): FirAnnotation {
    contract {
        callsInPlace(init, InvocationKind.EXACTLY_ONCE)
    }
    val copyBuilder = FirAnnotationBuilder()
    copyBuilder.source = original.source
    copyBuilder.useSiteTarget = original.useSiteTarget
    copyBuilder.annotationTypeRef = original.annotationTypeRef
    copyBuilder.argumentMapping = original.argumentMapping
    copyBuilder.typeArguments.addAll(original.typeArguments)
    return copyBuilder.apply(init).build()
}
