/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/fir/tree/tree-generator/Readme.md.
// DO NOT MODIFY IT MANUALLY.

@file:Suppress("DuplicatedCode", "unused")

package ksp.org.jetbrains.kotlin.fir.expressions.builder

import kotlin.contracts.*
import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.fir.builder.FirBuilderDsl
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock
import ksp.org.jetbrains.kotlin.fir.expressions.FirCatch
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirCatchImpl

@FirBuilderDsl
class FirCatchBuilder {
    var source: KtSourceElement? = null
    lateinit var parameter: FirProperty
    lateinit var block: FirBlock

    fun build(): FirCatch {
        return FirCatchImpl(
            source,
            parameter,
            block,
        )
    }

}

@OptIn(ExperimentalContracts::class)
inline fun buildCatch(init: FirCatchBuilder.() -> Unit): FirCatch {
    contract {
        callsInPlace(init, InvocationKind.EXACTLY_ONCE)
    }
    return FirCatchBuilder().apply(init).build()
}
