/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.scopes

import ksp.org.jetbrains.kotlin.descriptors.Visibility
import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.FirSessionComponent
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol

interface FirOverrideChecker : FirSessionComponent {
    fun isOverriddenFunction(
        overrideCandidate: FirSimpleFunction,
        baseDeclaration: FirSimpleFunction
    ): Boolean

    fun isOverriddenProperty(
        overrideCandidate: FirCallableDeclaration, // NB: in Java it can be a function which overrides accessor
        baseDeclaration: FirProperty
    ): Boolean

    fun chooseIntersectionVisibility(
        overrides: Collection<FirCallableSymbol<*>>,
        dispatchClassSymbol: FirRegularClassSymbol?,
    ): Visibility
}

fun FirOverrideChecker.isOverriddenFunction(
    overrideCandidate: FirNamedFunctionSymbol,
    baseDeclaration: FirNamedFunctionSymbol
): Boolean = isOverriddenFunction(overrideCandidate.fir, baseDeclaration.fir)

fun FirOverrideChecker.isOverriddenProperty(
    overrideCandidate: FirCallableSymbol<*>,
    baseDeclaration: FirPropertySymbol
): Boolean = isOverriddenProperty(overrideCandidate.fir, baseDeclaration.fir)

val FirSession.firOverrideChecker: FirOverrideChecker by FirSession.sessionComponentAccessor()
