/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.types.impl

import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.fir.types.FirQualifierPart
import ksp.org.jetbrains.kotlin.fir.types.FirTypeArgumentList
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection
import ksp.org.jetbrains.kotlin.name.Name

class FirTypeArgumentListImpl(override val source: KtSourceElement?) : FirTypeArgumentList {
    override val typeArguments: MutableList<FirTypeProjection> = mutableListOf()
}

class FirQualifierPartImpl(
    override val source: KtSourceElement?,
    override val name: Name,
    override val typeArgumentList: FirTypeArgumentList
) : FirQualifierPart
