/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.backend.js.lower

import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext
import ksp.org.jetbrains.kotlin.backend.common.lower.DefaultArgumentFunctionFactory
import ksp.org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin
import ksp.org.jetbrains.kotlin.ir.builders.declarations.addValueParameter
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction
import ksp.org.jetbrains.kotlin.ir.declarations.copyAttributes
import ksp.org.jetbrains.kotlin.ir.types.IrType
import ksp.org.jetbrains.kotlin.ir.types.makeNullable
import ksp.org.jetbrains.kotlin.ir.util.copyTypeParametersFrom
import ksp.org.jetbrains.kotlin.ir.util.defaultType
import ksp.org.jetbrains.kotlin.ir.util.isTopLevel
import ksp.org.jetbrains.kotlin.ir.util.parentAsClass
import ksp.org.jetbrains.kotlin.name.Name

class JsDefaultArgumentFunctionFactory(context: CommonBackendContext) : DefaultArgumentFunctionFactory(context) {

    override fun IrType.hasNullAsUndefinedValue() = false

    override fun IrFunction.generateDefaultArgumentStubFrom(original: IrFunction, useConstructorMarker: Boolean) {
        copyAttributes(original)
        copyTypeParametersFrom(original)
        copyReturnTypeFrom(original)
        copyValueParametersFrom(original)

        if (!original.isTopLevel) {
            introduceContextParam()
        }
    }

    private fun IrFunction.introduceContextParam() = addValueParameter {
        name = Name.identifier("\$super")
        type = parentAsClass.defaultType.makeNullable()
        origin = JsLoweredDeclarationOrigin.JS_SUPER_CONTEXT_PARAMETER
    }

}