/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir

import ksp.org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer
import ksp.org.jetbrains.kotlin.library.impl.toArray
import ksp.org.jetbrains.kotlin.library.encodings.WobblyTF8
import ksp.org.jetbrains.kotlin.library.impl.IrStringWriter
import ksp.org.jetbrains.kotlin.library.impl.IrArrayReader

class JsIrFileMetadata(val exportedNames: List<String>) : IrFileSerializer.FileBackendSpecificMetadata {
    override fun toByteArray(): ByteArray {
        return IrStringWriter(exportedNames).writeIntoMemory()
    }

    companion object {
        fun fromByteArray(data: ByteArray): JsIrFileMetadata {
            return JsIrFileMetadata(
                exportedNames = IrArrayReader(data).toArray().map(WobblyTF8::decode)
            )
        }
    }
}
