/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.js.resolve

import ksp.org.jetbrains.kotlin.container.StorageComponentContainer
import ksp.org.jetbrains.kotlin.container.useImpl
import ksp.org.jetbrains.kotlin.container.useInstance
import ksp.org.jetbrains.kotlin.js.analyze.JsNativeDiagnosticSuppressor
import ksp.org.jetbrains.kotlin.js.naming.JsNameSuggestion
import ksp.org.jetbrains.kotlin.js.naming.NameSuggestion
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.*
import ksp.org.jetbrains.kotlin.resolve.PlatformConfiguratorBase
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.LateinitIntrinsicApplicabilityChecker
import ksp.org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker
import ksp.org.jetbrains.kotlin.types.DynamicTypesAllowed

object JsPlatformConfigurator : PlatformConfiguratorBase(
    DynamicTypesAllowed(),
    additionalDeclarationCheckers = listOf(
        NativeInvokeChecker(), NativeGetterChecker(), NativeSetterChecker(),
        JsNameChecker, JsModuleChecker, JsExternalFileChecker,
        JsInheritanceChecker, JsMultipleInheritanceChecker,
        JsExternalInheritorOnlyChecker,
        JsRuntimeAnnotationChecker,
        JsDynamicDeclarationChecker,
        JsExportAnnotationChecker,
    ),
    additionalCallCheckers = listOf(
        JsModuleCallChecker,
        JsDynamicCallChecker,
        JsDefinedExternallyCallChecker,
        LateinitIntrinsicApplicabilityChecker(isWarningInPre19 = true),
        JsExternalArgumentCallChecker
    ),
) {
    override fun configureModuleComponents(container: StorageComponentContainer) {
        container.useImpl<JsCallChecker>()
        container.useImpl<JsTypeSpecificityComparator>()
        container.useImpl<JsNameClashChecker>()
        container.useImpl<JsIdentifierChecker>()
        container.useImpl<JsNameCharsChecker>()
        container.useImpl<JsBuiltinNameClashChecker>()
        container.useInstance(JsModuleClassLiteralChecker)
        container.useImpl<JsReflectionAPICallChecker>()
        container.useImpl<JsNativeRttiChecker>()
        container.useImpl<JsReifiedNativeChecker>()
        container.useInstance(ExtensionFunctionToExternalIsInlinable)
        container.useInstance(JsQualifierChecker)
        container.useInstance(JsNativeDiagnosticSuppressor)
        container.useInstance(JsExternalChecker(allowCompanionInInterface = true, allowUnsignedTypes = false))
        container.useInstance(JsExportDeclarationChecker(allowCompanionInInterface = true, includeUnsignedNumbers = false))
    }

    override fun configureModuleDependentCheckers(container: StorageComponentContainer) {
        super.configureModuleDependentCheckers(container)
        container.useImpl<ExpectedActualDeclarationChecker>()
    }
}
