/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.light.classes.symbol.methods

import ksp.com.intellij.psi.*
import ksp.org.jetbrains.kotlin.asJava.classes.METHOD_INDEX_BASE
import ksp.org.jetbrains.kotlin.asJava.classes.lazyPub
import ksp.org.jetbrains.kotlin.builtins.StandardNames
import ksp.org.jetbrains.kotlin.light.classes.symbol.cachedValue
import ksp.org.jetbrains.kotlin.light.classes.symbol.classes.SymbolLightClassBase
import ksp.org.jetbrains.kotlin.light.classes.symbol.modifierLists.InitializedModifiersBox
import ksp.org.jetbrains.kotlin.light.classes.symbol.modifierLists.SymbolLightMemberModifierList
import ksp.org.jetbrains.kotlin.light.classes.symbol.parameters.SymbolLightParameterList

internal class SymbolLightRepeatableAnnotationContainerMethod(
    private val annotationClassQualifier: String?,
    containingClass: SymbolLightClassBase,
) : SymbolLightMethodBase(
    lightMemberOrigin = null,
    containingClass = containingClass,
    methodIndex = METHOD_INDEX_BASE,
    isJvmExposedBoxed = false,
) {
    override fun getNameIdentifier(): PsiIdentifier? = null
    override fun isDeprecated(): Boolean = false
    override fun getName(): String = StandardNames.DEFAULT_VALUE_PARAMETER.asString()
    override fun getTypeParameters(): Array<PsiTypeParameter> = PsiTypeParameter.EMPTY_ARRAY
    override fun hasTypeParameters(): Boolean = false
    override fun getTypeParameterList(): PsiTypeParameterList? = null
    override fun isOverride(): Boolean = false

    override fun getModifierList(): PsiModifierList = cachedValue {
        SymbolLightMemberModifierList(
            containingDeclaration = this,
            modifiersBox = InitializedModifiersBox(PsiModifier.PUBLIC, PsiModifier.ABSTRACT),
        )
    }

    private val _parameterList by lazyPub {
        SymbolLightParameterList(this)
    }

    override fun getParameterList(): PsiParameterList = _parameterList

    override fun isVarArgs(): Boolean = false
    override fun isConstructor(): Boolean = false

    private val _returnType by lazyPub {
        val qualifier = annotationClassQualifier ?: return@lazyPub null
        JavaPsiFacade.getElementFactory(project).createTypeByFQClassName(qualifier, resolveScope).createArrayType()
    }

    override fun getReturnType(): PsiType? = _returnType

    override fun equals(other: Any?): Boolean =
        this === other || other is SymbolLightRepeatableAnnotationContainerMethod && other.containingClass == containingClass

    override fun hashCode(): Int = containingClass.hashCode()
    override fun copy(): PsiElement = SymbolLightRepeatableAnnotationContainerMethod(annotationClassQualifier, containingClass)
}
