/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl

import ksp.com.intellij.psi.stubs.StubElement
import ksp.com.intellij.util.io.StringRef
import ksp.org.jetbrains.kotlin.psi.KtEnumEntrySuperclassReferenceExpression
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinEnumEntrySuperclassReferenceExpressionStub
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes

class KotlinEnumEntrySuperclassReferenceExpressionStubImpl(
    parent: StubElement<*>,
    private val referencedNameRef: StringRef,
) : KotlinStubBaseImpl<KtEnumEntrySuperclassReferenceExpression>(parent, KtStubElementTypes.ENUM_ENTRY_SUPERCLASS_REFERENCE_EXPRESSION),
    KotlinEnumEntrySuperclassReferenceExpressionStub {
    override val referencedName: String get() = referencedNameRef.string
}
