/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.resolve.calls.checkers

import ksp.org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks
import ksp.org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext
import ksp.org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults
import ksp.org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower
import ksp.org.jetbrains.kotlin.types.UnwrappedType

interface CallCheckerWithAdditionalResolve {
    fun check(
        overloadResolutionResults: OverloadResolutionResults<*>,
        scopeTower: ImplicitScopeTower,
        resolutionCallbacks: KotlinResolutionCallbacks,
        expectedType: UnwrappedType?,
        context: BasicCallResolutionContext,
    )
}