/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.resolve.calls.model

import ksp.org.jetbrains.kotlin.resolve.calls.components.ArgumentsToCandidateParameterDescriptor
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckArgumentsInParenthesis
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckCallableReference
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckContextReceiversResolutionPart
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckExplicitReceiverKindConsistency
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckExternalArgument
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckIncompatibleTypeVariableUpperBounds
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckInfixResolutionPart
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckOperatorResolutionPart
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckReceivers
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckSuperExpressionCallPart
import ksp.org.jetbrains.kotlin.resolve.calls.components.CheckVisibility
import ksp.org.jetbrains.kotlin.resolve.calls.components.CollectionTypeVariableUsagesInfo
import ksp.org.jetbrains.kotlin.resolve.calls.components.CompatibilityOfPartiallyApplicableSamConversion
import ksp.org.jetbrains.kotlin.resolve.calls.components.CreateFreshVariablesSubstitutor
import ksp.org.jetbrains.kotlin.resolve.calls.components.EagerResolveOfCallableReferences
import ksp.org.jetbrains.kotlin.resolve.calls.components.MapArguments
import ksp.org.jetbrains.kotlin.resolve.calls.components.MapTypeArguments
import ksp.org.jetbrains.kotlin.resolve.calls.components.NoArguments
import ksp.org.jetbrains.kotlin.resolve.calls.components.NoTypeArguments
import ksp.org.jetbrains.kotlin.resolve.calls.components.PostponedVariablesInitializerResolutionPart

enum class KotlinCallKind(vararg resolutionPart: ResolutionPart) {
    VARIABLE(
        CheckVisibility,
        CheckSuperExpressionCallPart,
        NoTypeArguments,
        NoArguments,
        CreateFreshVariablesSubstitutor,
        CollectionTypeVariableUsagesInfo,
        CheckExplicitReceiverKindConsistency,
        CheckReceivers,
        PostponedVariablesInitializerResolutionPart,
        CheckContextReceiversResolutionPart,
        CheckIncompatibleTypeVariableUpperBounds
    ),
    FUNCTION(
        CheckVisibility,
        CheckInfixResolutionPart,
        CheckOperatorResolutionPart,
        CheckSuperExpressionCallPart,
        MapTypeArguments,
        MapArguments,
        ArgumentsToCandidateParameterDescriptor,
        CreateFreshVariablesSubstitutor,
        CollectionTypeVariableUsagesInfo,
        CheckExplicitReceiverKindConsistency,
        CheckReceivers,
        CheckArgumentsInParenthesis,
        CheckExternalArgument,
        EagerResolveOfCallableReferences,
        CompatibilityOfPartiallyApplicableSamConversion,
        PostponedVariablesInitializerResolutionPart,
        CheckContextReceiversResolutionPart,
        CheckIncompatibleTypeVariableUpperBounds
    ),
    INVOKE(*FUNCTION.resolutionSequence.toTypedArray()),
    CALLABLE_REFERENCE(
        CheckVisibility,
        NoTypeArguments,
        NoArguments,
        CreateFreshVariablesSubstitutor,
        CollectionTypeVariableUsagesInfo,
        CheckReceivers,
        CheckCallableReference,
        CheckIncompatibleTypeVariableUpperBounds
    ),
    UNSUPPORTED();

    val resolutionSequence = resolutionPart.asList()
}