/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.resolve.jvm.checkers

import ksp.com.intellij.psi.PsiElement
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor
import ksp.org.jetbrains.kotlin.name.FqName
import ksp.org.jetbrains.kotlin.name.StandardClassIds
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.classId
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver

object EnumDeclaringClassDeprecationChecker : CallChecker {
    override fun check(resolvedCall: ResolvedCall<*>, reportOn: PsiElement, context: CallCheckerContext) {
        val resultingDescriptor = resolvedCall.resultingDescriptor
        if (resultingDescriptor !is PropertyDescriptor || resultingDescriptor.kind != CallableMemberDescriptor.Kind.SYNTHESIZED) return
        val extensionReceiver = resultingDescriptor.extensionReceiverParameter?.value as? ExtensionReceiver ?: return
        if (resultingDescriptor.name.asString() != "declaringClass") return
        val extensionReceiverConstructor = extensionReceiver.type.constructor
        if (extensionReceiverConstructor.declarationDescriptor.classId != StandardClassIds.Enum &&
            extensionReceiverConstructor.supertypes.none { it.constructor.declarationDescriptor.classId == StandardClassIds.Enum }
        ) return
        context.trace.report(ErrorsJvm.ENUM_DECLARING_CLASS_DEPRECATED.on(context.languageVersionSettings, reportOn))
    }
}