/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.abt;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.firebase_abt.zzi;
import com.google.android.gms.internal.firebase_abt.zzj;
import com.google.android.gms.internal.firebase_abt.zzn;
import com.google.android.gms.internal.firebase_abt.zzo;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@KeepForSdk
public class FirebaseABTesting {
    private AppMeasurement zza;
    private String zzb;
    private int zzc;
    private long zzd;
    private SharedPreferences zze;
    private String zzf;
    @Nullable
    private Integer zzg;

    @KeepForSdk
    public FirebaseABTesting(Context context, String string, int n) throws NoClassDefFoundError {
        this.zza = AppMeasurement.getInstance((Context)context);
        this.zzb = string;
        this.zzc = n;
        this.zzg = null;
        this.zze = context.getSharedPreferences("com.google.firebase.abt", 0);
        this.zzf = String.format("%s_lastKnownExperimentStartTime", string);
        this.zzd = this.zze.getLong(this.zzf, 0L);
    }

    @WorkerThread
    @KeepForSdk
    public void addExperiment(byte[] byArray) {
        zzo zzo2 = FirebaseABTesting.zza(byArray);
        if (zzo2 != null) {
            boolean bl;
            int n;
            zzo zzo3 = zzo2;
            FirebaseABTesting firebaseABTesting = this;
            if (zzo3.zzbb == null || zzo3.zzbb.length == 0) {
                Log.e((String)"FirebaseABTesting", (String)"The ongoingExperiments field of the payload is not defined.");
                return;
            }
            Object object = zzo3.zzbb;
            HashSet<String> hashSet = new HashSet<String>();
            zzn[] zznArray = object;
            int n2 = ((zzn[])object).length;
            for (int i = 0; i < n2; ++i) {
                zzn zzn2 = zznArray[i];
                hashSet.add(zzn2.zzaq);
            }
            HashSet<String> hashSet2 = hashSet;
            if (!hashSet2.contains(zzo3.zzaq)) {
                Log.e((String)"FirebaseABTesting", (String)String.format("The payload experiment [%s, %s] is not in ongoingExperiments.", zzo3.zzaq, zzo3.zzar));
                return;
            }
            firebaseABTesting.zzd = Math.max(firebaseABTesting.zzd, zzo3.zzas);
            firebaseABTesting.zza();
            ArrayDeque<AppMeasurement.ConditionalUserProperty> arrayDeque = new ArrayDeque<AppMeasurement.ConditionalUserProperty>();
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>();
            for (AppMeasurement.ConditionalUserProperty conditionalUserProperty : firebaseABTesting.zzb()) {
                if (conditionalUserProperty.mName.equals(zzo3.zzaq)) {
                    Log.w((String)"FirebaseABTesting", (String)String.format("The payload experiment [%s, %s] is already set with variant: %s", zzo3.zzaq, zzo3.zzar, conditionalUserProperty.mValue));
                    return;
                }
                if (hashSet2.contains(conditionalUserProperty.mName)) {
                    arrayDeque.offer(conditionalUserProperty);
                    continue;
                }
                arrayList.add(conditionalUserProperty);
            }
            int n3 = arrayDeque.size();
            if (n3 >= (n = firebaseABTesting.zzc())) {
                if (n3 > n) {
                    Log.w((String)"FirebaseABTesting", (String)String.format("Max experiment limit exceeded: %d > %d", n3, n));
                }
                bl = false;
            } else {
                bl = true;
            }
            if (bl || firebaseABTesting.zza(zzo3)) {
                firebaseABTesting.zza(arrayList);
                ArrayDeque<AppMeasurement.ConditionalUserProperty> arrayDeque2 = arrayDeque;
                object = firebaseABTesting;
                while (arrayDeque2.size() >= super.zzc()) {
                    AppMeasurement.ConditionalUserProperty conditionalUserProperty = (AppMeasurement.ConditionalUserProperty)arrayDeque2.pollFirst();
                    if (Log.isLoggable((String)"FirebaseABTesting", (int)3)) {
                        Log.d((String)"FirebaseABTesting", (String)String.format("Clearing experiment due to the overflow policy: [%s, %s]", conditionalUserProperty.mName, conditionalUserProperty.mValue));
                    }
                    super.zza(conditionalUserProperty.mName);
                }
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = firebaseABTesting.zzb(zzo3);
                firebaseABTesting.zza.setConditionalUserProperty(conditionalUserProperty);
            }
        }
    }

    @WorkerThread
    @KeepForSdk
    public void replaceAllExperiments(List<byte[]> list) {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        if (list == null) {
            Log.e((String)"FirebaseABTesting", (String)"Cannot replace experiments because experimentPayloads is null.");
            return;
        }
        if (list.isEmpty()) {
            this.removeAllExperiments();
            return;
        }
        Object object5 = list;
        Object object6 = new ArrayList();
        Object object7 = object5.iterator();
        while (object7.hasNext()) {
            object4 = FirebaseABTesting.zza(object7.next());
            if (object4 == null) continue;
            object6.add(object4);
        }
        object5 = this;
        if (object6.isEmpty()) {
            Log.e((String)"FirebaseABTesting", (String)"All payloads are either not defined or cannot not be deserialized.");
            return;
        }
        object7 = new HashSet();
        Object object8 = object6;
        int n = object8.size();
        List<AppMeasurement.ConditionalUserProperty> list2 = null;
        for (int i = 0; i < n; ++i) {
            Object e = object8.get(i);
            object4 = (zzo)e;
            object7.add(((zzo)object4).zzaq);
        }
        list2 = super.zzb();
        object4 = new HashSet();
        for (Object object32 : list2) {
            object4.add(object32.mName);
        }
        Object object9 = object7;
        Object object10 = list2;
        ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>();
        Iterator<AppMeasurement.ConditionalUserProperty> iterator = object10.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object9.contains(object2.mName)) continue;
            arrayList.add((AppMeasurement.ConditionalUserProperty)object2);
        }
        ArrayList<AppMeasurement.ConditionalUserProperty> arrayList2 = arrayList;
        super.zza((Collection<AppMeasurement.ConditionalUserProperty>)arrayList2);
        ArrayDeque<AppMeasurement.ConditionalUserProperty> arrayDeque = object4;
        object9 = object6;
        object10 = object5;
        arrayList = new ArrayList();
        Object object11 = object9;
        int n2 = object11.size();
        int n3 = 0;
        iterator = null;
        while (n3 < n2) {
            boolean bl;
            Object e = object11.get(n3);
            ++n3;
            object2 = (zzo)e;
            if (arrayDeque.contains(object2.zzaq)) continue;
            Object object12 = object2;
            object = object10;
            if (object12.zzas <= ((FirebaseABTesting)object).zzd) {
                if (Log.isLoggable((String)"FirebaseABTesting", (int)3)) {
                    Log.d((String)"FirebaseABTesting", (String)String.format("The experiment [%s, %s, %d] is not new since its startTime is before lastKnownStartTime: %d", object12.zzaq, object12.zzar, object12.zzas, ((FirebaseABTesting)object).zzd));
                }
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) continue;
            arrayList.add((AppMeasurement.ConditionalUserProperty)object2);
        }
        object9 = object32 = arrayList;
        object10 = object5;
        arrayDeque = new ArrayDeque<AppMeasurement.ConditionalUserProperty>(super.zzb());
        int n4 = super.zzc();
        ArrayList arrayList3 = (ArrayList)object9;
        int n5 = arrayList3.size();
        int n6 = 0;
        iterator = null;
        while (n6 < n5) {
            Object e = arrayList3.get(n6);
            ++n6;
            object2 = (zzo)e;
            if (arrayDeque.size() >= n4) {
                if (!super.zza((zzo)object2)) continue;
                while (arrayDeque.size() >= n4) {
                    super.zza(((AppMeasurement.ConditionalUserProperty)arrayDeque.pollFirst()).mName);
                }
            }
            object = super.zzb((zzo)object2);
            ((FirebaseABTesting)object10).zza.setConditionalUserProperty((AppMeasurement.ConditionalUserProperty)object);
            arrayDeque.offer((AppMeasurement.ConditionalUserProperty)object);
        }
        object9 = object6;
        object10 = object5;
        ArrayList arrayList4 = (ArrayList)object9;
        int n7 = arrayList4.size();
        arrayDeque = null;
        for (int i = 0; i < n7; ++i) {
            Object e = arrayList4.get(i);
            zzo zzo2 = (zzo)e;
            ((FirebaseABTesting)object10).zzd = Math.max(((FirebaseABTesting)object10).zzd, zzo2.zzas);
        }
        super.zza();
    }

    @WorkerThread
    @KeepForSdk
    public void removeAllExperiments() {
        this.zza(this.zzb());
    }

    @VisibleForTesting
    private final void zza(String string) {
        this.zza.clearConditionalUserProperty(string, null, null);
    }

    private final void zza(Collection<AppMeasurement.ConditionalUserProperty> collection) {
        for (AppMeasurement.ConditionalUserProperty conditionalUserProperty : collection) {
            this.zza(conditionalUserProperty.mName);
        }
    }

    private final boolean zza(zzo zzo2) {
        int n = this.zzc;
        int n2 = zzo2.zzc;
        if ((n2 != 0 ? n2 : (n != 0 ? n : 1)) != 1) {
            if (Log.isLoggable((String)"FirebaseABTesting", (int)3)) {
                Log.d((String)"FirebaseABTesting", (String)String.format("Experiment won't be set due to the overflow policy: [%s, %s]", zzo2.zzaq, zzo2.zzar));
            }
            return false;
        }
        return true;
    }

    private final AppMeasurement.ConditionalUserProperty zzb(zzo zzo2) {
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mOrigin = this.zzb;
        conditionalUserProperty.mCreationTimestamp = zzo2.zzas;
        conditionalUserProperty.mName = zzo2.zzaq;
        conditionalUserProperty.mValue = zzo2.zzar;
        conditionalUserProperty.mTriggerEventName = TextUtils.isEmpty((CharSequence)zzo2.zzat) ? null : zzo2.zzat;
        conditionalUserProperty.mTriggerTimeout = zzo2.zzau;
        conditionalUserProperty.mTimeToLive = zzo2.zzav;
        return conditionalUserProperty;
    }

    private final void zza() {
        if (this.zze.getLong(this.zzf, 0L) == this.zzd) {
            return;
        }
        SharedPreferences.Editor editor = this.zze.edit();
        editor.putLong(this.zzf, this.zzd);
        editor.apply();
    }

    @WorkerThread
    private final List<AppMeasurement.ConditionalUserProperty> zzb() {
        return this.zza.getConditionalUserProperties(this.zzb, "");
    }

    @WorkerThread
    private final int zzc() {
        if (this.zzg == null) {
            this.zzg = this.zza.getMaxUserProperties(this.zzb);
        }
        return this.zzg;
    }

    private static zzo zza(byte[] byArray) {
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = byArray;
            return zzj.zza(new zzo(), byArray2, 0, byArray3.length);
        }
        catch (zzi zzi2) {
            Log.e((String)"FirebaseABTesting", (String)"Payload was not defined or could not be deserialized.", (Throwable)zzi2);
            return null;
        }
    }
}

