/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzaas;
import com.google.android.gms.internal.zzacx;
import com.google.android.gms.internal.zzatd;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzatr;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class zzast
extends zzatr {
    static final String zzbqo = String.valueOf(zzc.GOOGLE_PLAY_SERVICES_VERSION_CODE / 1000).replaceAll("(\\d+)(\\d)(\\d\\d)", "$1.$2.$3");
    private Boolean zzadY;

    zzast(zzatp zzatp2) {
        super(zzatp2);
    }

    String zzJS() {
        return zzatd.zzbqV.get();
    }

    public int zzJT() {
        return 25;
    }

    public int zzJU() {
        return 40;
    }

    public int zzJV() {
        return 24;
    }

    int zzJW() {
        return 40;
    }

    int zzJX() {
        return 100;
    }

    int zzJY() {
        return 256;
    }

    public int zzJZ() {
        return 36;
    }

    public int zzKa() {
        return 2048;
    }

    int zzKb() {
        return 500;
    }

    public long zzKc() {
        return zzatd.zzbrf.get().intValue();
    }

    public long zzKd() {
        return zzatd.zzbrh.get().intValue();
    }

    public int zzfn(@Size(min=1L) String string) {
        int n = this.zzb(string, zzatd.zzbrg);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzfo(@Size(min=1L) String string) {
        return this.zzb(string, zzatd.zzbri);
    }

    public int zzfp(@Size(min=1L) String string) {
        return this.zzb(string, zzatd.zzbrj);
    }

    int zzKe() {
        return 25;
    }

    int zzKf() {
        return 50;
    }

    long zzKg() {
        return 3600000L;
    }

    long zzKh() {
        return 60000L;
    }

    long zzKi() {
        return 61000L;
    }

    long zzfq(String string) {
        return this.zza(string, zzatd.zzbqW);
    }

    int zzfr(String string) {
        return this.zzb(string, zzatd.zzbry);
    }

    int zzfs(String string) {
        int n = this.zzb(string, zzatd.zzbrz);
        n = Math.min(2000, n);
        n = Math.max(0, n);
        return n;
    }

    long zzoQ() {
        return zzatd.zzbrA.get();
    }

    public String zzoV() {
        return "google_app_measurement.db";
    }

    String zzKj() {
        return "google_app_measurement_local.db";
    }

    public long zzJD() {
        return 10084L;
    }

    public boolean zzKk() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzow() {
        if (this.zzadY == null) {
            zzast zzast2 = this;
            synchronized (zzast2) {
                if (this.zzadY == null) {
                    ApplicationInfo applicationInfo = this.getContext().getApplicationInfo();
                    String string = zzt.zzyK();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzadY = string2 != null && string2.equals(string);
                    }
                    if (this.zzadY == null) {
                        this.zzadY = Boolean.TRUE;
                        this.zzJt().zzLa().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzadY;
    }

    public long zza(String string, zzatd.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzJq().zzW(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.valueOf(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    public int zzb(String string, zzatd.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzJq().zzW(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.valueOf(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @Nullable
    Boolean zzft(@Size(min=1L) String string) {
        zzac.zzdv((String)string);
        try {
            PackageManager packageManager = this.getContext().getPackageManager();
            if (packageManager == null) {
                this.zzJt().zzLa().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = zzacx.zzaQ((Context)this.getContext()).getApplicationInfo(this.getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                this.zzJt().zzLa().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                this.zzJt().zzLa().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzJt().zzLa().zzj("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public boolean zzKl() {
        Boolean bl = this.zzft("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public Boolean zzKm() {
        return this.zzft("firebase_analytics_collection_enabled");
    }

    public boolean zzwk() {
        return zzaas.zzwk();
    }

    public long zzKn() {
        return zzatd.zzbrx.get();
    }

    public long zzKo() {
        return zzatd.zzbrs.get();
    }

    public long zzKp() {
        return zzatd.zzbrt.get();
    }

    public long zzKq() {
        return 1000L;
    }

    public long zzoZ() {
        return Math.max(0L, zzatd.zzbqX.get());
    }

    public int zzfu(String string) {
        return this.zzb(string, zzatd.zzbrb);
    }

    public int zzfv(String string) {
        return Math.max(0, this.zzb(string, zzatd.zzbrc));
    }

    public int zzfw(String string) {
        int n = this.zzb(string, zzatd.zzbrk);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzKr() {
        return Math.max(0, zzatd.zzbrd.get());
    }

    public int zzKs() {
        return Math.max(1, zzatd.zzbre.get());
    }

    public int zzKt() {
        return 100000;
    }

    public String zzKu() {
        return zzatd.zzbrl.get();
    }

    public String zzO(String string, String string2) {
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string);
        builder.scheme(zzatd.zzbqZ.get()).encodedAuthority(zzatd.zzbra.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string2).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(10084L));
        return builder.build().toString();
    }

    public long zzKv() {
        return zzatd.zzbqY.get();
    }

    public long zzKw() {
        return Math.max(0L, zzatd.zzbrm.get());
    }

    public long zzKx() {
        return Math.max(0L, zzatd.zzbro.get());
    }

    public long zzKy() {
        return Math.max(0L, zzatd.zzbrp.get());
    }

    public long zzKz() {
        return Math.max(0L, zzatd.zzbrq.get());
    }

    public long zzKA() {
        return Math.max(0L, zzatd.zzbrr.get());
    }

    public long zzKB() {
        return zzatd.zzbrn.get();
    }

    public long zzKC() {
        return Math.max(0L, zzatd.zzbru.get());
    }

    public long zzKD() {
        return Math.max(0L, zzatd.zzbrv.get());
    }

    public int zzKE() {
        return Math.min(20, Math.max(0, zzatd.zzbrw.get()));
    }

    public String zzKF() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class, String.class);
            return (String)method.invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzJt().zzLa().zzj("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzJt().zzLa().zzj("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzJt().zzLa().zzj("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzJt().zzLa().zzj("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }
}

