/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzasp;
import com.google.android.gms.internal.zzasx;
import com.google.android.gms.internal.zzasy;
import com.google.android.gms.internal.zzati;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzatz;
import com.google.android.gms.internal.zzaud;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauf;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzbul;
import com.google.android.gms.internal.zzbum;
import com.google.android.gms.internal.zzbut;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zzasu
extends zzats {
    private static final Map<String, String> zzbqp = new ArrayMap(18);
    private static final Map<String, String> zzbqq;
    private static final Map<String, String> zzbqr;
    private static final Map<String, String> zzbqs;
    private final zzc zzbqt;
    private final zzatz zzbqu = new zzatz(this.zznq());

    zzasu(zzatp zzatp2) {
        super(zzatp2);
        String string = this.zznV();
        this.zzbqt = new zzc(this.getContext(), string);
    }

    @Override
    protected void zzmr() {
    }

    @WorkerThread
    public void beginTransaction() {
        this.zznA();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public void setTransactionSuccessful() {
        this.zznA();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public void endTransaction() {
        this.zznA();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzJt().zzLa().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            return l;
        }
    }

    @WorkerThread
    SQLiteDatabase getWritableDatabase() {
        this.zzmq();
        try {
            return this.zzbqt.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLc().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    String zznV() {
        return this.zzJv().zzoV();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzasy zzP(String string, String string2) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        this.zzmq();
        this.zznA();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzasy zzasy2 = new zzasy(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzJt().zzLa().zzj("Got multiple records for event aggregates, expected one. appId", zzati.zzfI(string));
            }
            zzasy zzasy3 = zzasy2;
            return zzasy3;
        }
    }

    @WorkerThread
    public void zza(zzasy zzasy2) {
        zzac.zzw((Object)zzasy2);
        this.zzmq();
        this.zznA();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzasy2.zzVQ);
        contentValues.put("name", zzasy2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzasy2.zzbqJ));
        contentValues.put("current_bundle_count", Long.valueOf(zzasy2.zzbqK));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzasy2.zzbqL));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("events", null, contentValues, 5);
            if (l == -1L) {
                this.zzJt().zzLa().zzj("Failed to insert/update event aggregates (got -1). appId", zzati.zzfI(zzasy2.zzVQ));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing event aggregates. appId", zzati.zzfI(zzasy2.zzVQ), (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzQ(String string, String string2) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        this.zzmq();
        this.zznA();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = sQLiteDatabase.delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzJt().zzLg().zzj("Deleted user attribute rows:", n);
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zzd("Error deleting user attribute. appId", zzati.zzfI(string), string2, (Object)sQLiteException);
        }
    }

    @WorkerThread
    public void zzz(String string, int n) {
        zzac.zzdv((String)string);
        this.zzmq();
        this.zznA();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string, string, String.valueOf(n)});
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error pruning currencies. appId", zzati.zzfI(string), (Object)sQLiteException);
        }
    }

    @WorkerThread
    public boolean zza(zzaud zzaud2) {
        zzac.zzw((Object)zzaud2);
        this.zzmq();
        this.zznA();
        zzaud zzaud3 = this.zzR(zzaud2.zzVQ, zzaud2.mName);
        if (zzaud3 == null) {
            long l;
            if (zzaue.zzfW(zzaud2.mName)) {
                l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzaud2.zzVQ});
                this.zzJv().zzKe();
                if (l >= 25L) {
                    return false;
                }
            } else {
                l = this.zzb("select count(1) from user_attributes where app_id=?", new String[]{zzaud2.zzVQ});
                this.zzJv().zzKf();
                if (l >= 50L) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzaud2.zzVQ);
        contentValues.put("name", zzaud2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzaud2.zzbvd));
        this.zza(contentValues, "value", zzaud2.zzYe);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("user_attributes", null, contentValues, 5);
            if (l == -1L) {
                this.zzJt().zzLa().zzj("Failed to insert/update user property (got -1). appId", zzati.zzfI(zzaud2.zzVQ));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing user property. appId", zzati.zzfI(zzaud2.zzVQ), (Object)sQLiteException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzaud zzR(String string, String string2) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        this.zzmq();
        this.zznA();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"set_timestamp", "value"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zzb(cursor, 1);
            zzaud zzaud2 = new zzaud(string, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzJt().zzLa().zzj("Got multiple records for user property, expected one. appId", zzati.zzfI(string));
            }
            zzaud zzaud3 = zzaud2;
            return zzaud3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<zzaud> zzfx(String string) {
        zzac.zzdv((String)string);
        this.zzmq();
        this.zznA();
        ArrayList<zzaud> arrayList = new ArrayList<zzaud>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("user_attributes", new String[]{"name", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(this.zzJv().zzKf()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzaud> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zzb(cursor, 2);
                if (object2 == null) {
                    this.zzJt().zzLa().zzj("Read invalid user property value, ignoring it. appId", zzati.zzfI(string));
                    continue;
                }
                zzaud zzaud2 = new zzaud(string, (String)object, l, object2);
                arrayList.add(zzaud2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zzasp zzfy(String string) {
        zzac.zzdv((String)string);
        this.zzmq();
        this.zznA();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzasp zzasp2 = new zzasp(this.zzbpw, string);
            zzasp2.zzfh(cursor.getString(0));
            zzasp2.zzfi(cursor.getString(1));
            zzasp2.zzfj(cursor.getString(2));
            zzasp2.zzac(cursor.getLong(3));
            zzasp2.zzX(cursor.getLong(4));
            zzasp2.zzY(cursor.getLong(5));
            zzasp2.setAppVersion(cursor.getString(6));
            zzasp2.zzfl(cursor.getString(7));
            zzasp2.zzaa(cursor.getLong(8));
            zzasp2.zzab(cursor.getLong(9));
            zzasp2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zzasp2.zzaf(cursor.getLong(11));
            zzasp2.zzag(cursor.getLong(12));
            zzasp2.zzah(cursor.getLong(13));
            zzasp2.zzai(cursor.getLong(14));
            zzasp2.zzad(cursor.getLong(15));
            zzasp2.zzae(cursor.getLong(16));
            zzasp2.zzZ(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzasp2.zzfk(cursor.getString(18));
            zzasp2.zzak(cursor.getLong(19));
            zzasp2.zzaj(cursor.getLong(20));
            zzasp2.zzfm(cursor.getString(21));
            zzasp2.zzJw();
            if (cursor.moveToNext()) {
                this.zzJt().zzLa().zzj("Got multiple records for app, expected one. appId", zzati.zzfI(string));
            }
            zzasp zzasp3 = zzasp2;
            return zzasp3;
        }
    }

    @WorkerThread
    public void zza(zzasp zzasp2) {
        zzac.zzw((Object)zzasp2);
        this.zzmq();
        this.zznA();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzasp2.zzjI());
        contentValues.put("app_instance_id", zzasp2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzasp2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzasp2.zzJx());
        contentValues.put("last_bundle_index", Long.valueOf(zzasp2.zzJG()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzasp2.zzJz()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzasp2.zzJA()));
        contentValues.put("app_version", zzasp2.zzmy());
        contentValues.put("app_store", zzasp2.zzJC());
        contentValues.put("gmp_version", Long.valueOf(zzasp2.zzJD()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzasp2.zzJE()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzasp2.zzJF()));
        contentValues.put("day", Long.valueOf(zzasp2.zzJK()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzasp2.zzJL()));
        contentValues.put("daily_events_count", Long.valueOf(zzasp2.zzJM()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzasp2.zzJN()));
        contentValues.put("config_fetched_time", Long.valueOf(zzasp2.zzJH()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzasp2.zzJI()));
        contentValues.put("app_version_int", Long.valueOf(zzasp2.zzJB()));
        contentValues.put("firebase_instance_id", zzasp2.zzJy());
        contentValues.put("daily_error_events_count", Long.valueOf(zzasp2.zzJP()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzasp2.zzJO()));
        contentValues.put("health_monitor_sample", zzasp2.zzJQ());
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5);
            if (l == -1L) {
                this.zzJt().zzLa().zzj("Failed to insert/update app (got -1). appId", zzati.zzfI(zzasp2.zzjI()));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing app. appId", zzati.zzfI(zzasp2.zzjI()), (Object)sQLiteException);
        }
    }

    public long zzfz(String string) {
        zzac.zzdv((String)string);
        this.zzmq();
        this.zznA();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = String.valueOf(this.zzJv().zzfw(string));
            long l = sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string2});
            return l;
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error deleting over the limit events. appId", zzati.zzfI(string), (Object)sQLiteException);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public zza zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzac.zzdv((String)string);
        this.zzmq();
        this.zznA();
        String[] stringArray = new String[]{string};
        zza zza2 = new zza();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzJt().zzLc().zzj("Not updating daily counts, app is not known. appId", zzati.zzfI(string));
                zza zza3 = zza2;
                return zza3;
            }
            long l2 = cursor.getLong(0);
            if (l2 == l) {
                zza2.zzbqw = cursor.getLong(1);
                zza2.zzbqv = cursor.getLong(2);
                zza2.zzbqx = cursor.getLong(3);
                zza2.zzbqy = cursor.getLong(4);
                zza2.zzbqz = cursor.getLong(5);
            }
            if (bl) {
                ++zza2.zzbqw;
            }
            if (bl2) {
                ++zza2.zzbqv;
            }
            if (bl3) {
                ++zza2.zzbqx;
            }
            if (bl4) {
                ++zza2.zzbqy;
            }
            if (bl5) {
                ++zza2.zzbqz;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zza2.zzbqv));
            contentValues.put("daily_events_count", Long.valueOf(zza2.zzbqw));
            contentValues.put("daily_conversions_count", Long.valueOf(zza2.zzbqx));
            contentValues.put("daily_error_events_count", Long.valueOf(zza2.zzbqy));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zza2.zzbqz));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zza zza4 = zza2;
            return zza4;
        }
    }

    @WorkerThread
    public void zzd(String string, byte[] byArray) {
        zzac.zzdv((String)string);
        this.zzmq();
        this.zznA();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            long l = sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{string});
            if (l == 0L) {
                this.zzJt().zzLa().zzj("Failed to update remote config (got 0). appId", zzati.zzfI(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing remote config. appId", zzati.zzfI(string), (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zzfA(String string) {
        zzac.zzdv((String)string);
        this.zzmq();
        this.zznA();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzJt().zzLa().zzj("Got multiple records for app config, expected one. appId", zzati.zzfI(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public void zza(zzauh.zze zze2, boolean bl) {
        byte[] byArray;
        Object object;
        this.zzmq();
        this.zznA();
        zzac.zzw((Object)((Object)zze2));
        zzac.zzdv((String)zze2.zzaR);
        zzac.zzw((Object)zze2.zzbwh);
        this.zzKI();
        long l = this.zznq().currentTimeMillis();
        if (zze2.zzbwh < l - this.zzJv().zzKn() || zze2.zzbwh > l + this.zzJv().zzKn()) {
            this.zzJt().zzLc().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzati.zzfI(zze2.zzaR), l, zze2.zzbwh);
        }
        try {
            int n = zze2.zzacZ();
            object = new byte[n];
            zzbum zzbum2 = zzbum.zzae((byte[])object);
            zze2.zza(zzbum2);
            zzbum2.zzacM();
            byArray = this.zzJp().zzk((byte[])object);
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zze("Data loss. Failed to serialize bundle. appId", zzati.zzfI(zze2.zzaR), iOException);
            return;
        }
        this.zzJt().zzLg().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzaR);
        contentValues.put("bundle_end_timestamp", zze2.zzbwh);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            object = this.getWritableDatabase();
            long l2 = object.insert("queue", null, contentValues);
            if (l2 == -1L) {
                this.zzJt().zzLa().zzj("Failed to insert bundle (got -1). appId", zzati.zzfI(zze2.zzaR));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing bundle. appId", zzati.zzfI(zze2.zzaR), (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public String zzKG() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue where app_id not in (select app_id from apps where measurement_enabled=0) order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public boolean zzKH() {
        long l = this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null);
        return l != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public List<Pair<zzauh.zze, Long>> zzn(String string, int n, int n2) {
        this.zzmq();
        this.zznA();
        zzac.zzas((n > 0 ? 1 : 0) != 0);
        zzac.zzas((n2 > 0 ? 1 : 0) != 0);
        zzac.zzdv((String)string);
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzauh.zze, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzauh.zze, Long>> arrayList = new ArrayList<Pair<zzauh.zze, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzJp().zzx((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzJt().zzLa().zze("Failed to unzip queued bundle. appId", zzati.zzfI(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                object = zzbul.zzad((byte[])byArray);
                zzauh.zze zze2 = new zzauh.zze();
                try {
                    zze2.zzb((zzbul)object);
                }
                catch (IOException iOException) {
                    this.zzJt().zzLa().zze("Failed to merge queued bundle. appId", zzati.zzfI(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzauh.zze, Long>)Pair.create((Object)((Object)zze2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzauh.zze, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    public void zzal(long l) {
        this.zzmq();
        this.zznA();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(l)};
        int n = sQLiteDatabase.delete("queue", "rowid=?", stringArray);
        if (n != 1) {
            this.zzJt().zzLa().log("Deleted fewer rows from queue than expected");
        }
    }

    @WorkerThread
    void zzKI() {
        this.zzmq();
        this.zznA();
        if (!this.zzKP()) {
            return;
        }
        long l = this.zzJu().zzbsj.get();
        long l2 = this.zznq().elapsedRealtime();
        if (Math.abs(l2 - l) > this.zzJv().zzKo()) {
            this.zzJu().zzbsj.set(l2);
            this.zzKJ();
        }
    }

    @WorkerThread
    void zzKJ() {
        this.zzmq();
        this.zznA();
        if (!this.zzKP()) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String[] stringArray = new String[]{String.valueOf(this.zznq().currentTimeMillis()), String.valueOf(this.zzJv().zzKn())};
        int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
        if (n > 0) {
            this.zzJt().zzLg().zzj("Deleted stale rows. rowsDeleted", n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, zzauf.zza[] zzaArray) {
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        zzac.zzw((Object)zzaArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            this.zzfB(string);
            for (zzauf.zza zza2 : zzaArray) {
                this.zza(string, zza2);
            }
            ArrayList arrayList = new ArrayList();
            for (zzauf.zza zza3 : zzaArray) {
                arrayList.add(zza3.zzbvh);
            }
            this.zzc(string, arrayList);
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    void zzfB(String string) {
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=?", new String[]{string});
        sQLiteDatabase.delete("event_filters", "app_id=?", new String[]{string});
    }

    @WorkerThread
    void zzA(String string, int n) {
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("property_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
        sQLiteDatabase.delete("event_filters", "app_id=? and audience_id=?", new String[]{string, String.valueOf(n)});
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void zza(String string, zzauf.zza zza2) {
        void var7_13;
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        zzac.zzw((Object)((Object)zza2));
        zzac.zzw((Object)zza2.zzbvj);
        zzac.zzw((Object)zza2.zzbvi);
        if (zza2.zzbvh == null) {
            this.zzJt().zzLc().zzj("Audience with no ID. appId", zzati.zzfI(string));
            return;
        }
        int n = zza2.zzbvh;
        for (zzauf.zzb zzb2 : zza2.zzbvj) {
            if (zzb2.zzbvl != null) continue;
            this.zzJt().zzLc().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzati.zzfI(string), zza2.zzbvh);
            return;
        }
        for (zzbut zzbut2 : zza2.zzbvi) {
            if (zzbut2.zzbvl != null) continue;
            this.zzJt().zzLc().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzati.zzfI(string), zza2.zzbvh);
            return;
        }
        boolean bl = true;
        zzbut[] zzbutArray = zza2.zzbvj;
        int n2 = zzbutArray.length;
        boolean bl2 = false;
        while (var7_13 < n2) {
            zzauf.zzb zzb2 = zzbutArray[var7_13];
            if (!this.zza(string, n, zzb2)) {
                bl = false;
                break;
            }
            ++var7_13;
        }
        if (bl) {
            void var7_15;
            zzbutArray = zza2.zzbvi;
            n2 = zzbutArray.length;
            boolean bl3 = false;
            while (var7_15 < n2) {
                zzbut zzbut3 = zzbutArray[var7_15];
                if (!this.zza(string, n, (zzauf.zze)zzbut3)) {
                    bl = false;
                    break;
                }
                ++var7_15;
            }
        }
        if (!bl) {
            this.zzA(string, n);
        }
    }

    @WorkerThread
    private boolean zza(String string, int n, zzauf.zzb zzb2) {
        zzbum zzbum2;
        byte[] byArray;
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        zzac.zzw((Object)((Object)zzb2));
        if (TextUtils.isEmpty((CharSequence)zzb2.zzbvm)) {
            this.zzJt().zzLc().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzati.zzfI(string), n, String.valueOf(zzb2.zzbvl));
            return false;
        }
        try {
            int n2 = zzb2.zzacZ();
            byArray = new byte[n2];
            zzbum2 = zzbum.zzae((byte[])byArray);
            zzb2.zza(zzbum2);
            zzbum2.zzacM();
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zze("Configuration loss. Failed to serialize event filter. appId", zzati.zzfI(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.zzbvl);
        contentValues.put("event_name", zzb2.zzbvm);
        contentValues.put("data", byArray);
        try {
            zzbum2 = this.getWritableDatabase();
            long l = zzbum2.insertWithOnConflict("event_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzJt().zzLa().zzj("Failed to insert event filter (got -1). appId", zzati.zzfI(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing event filter. appId", zzati.zzfI(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private boolean zza(String string, int n, zzauf.zze zze2) {
        zzbum zzbum2;
        byte[] byArray;
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        zzac.zzw((Object)((Object)zze2));
        if (TextUtils.isEmpty((CharSequence)zze2.zzbvB)) {
            this.zzJt().zzLc().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzati.zzfI(string), n, String.valueOf(zze2.zzbvl));
            return false;
        }
        try {
            int n2 = zze2.zzacZ();
            byArray = new byte[n2];
            zzbum2 = zzbum.zzae((byte[])byArray);
            zze2.zza(zzbum2);
            zzbum2.zzacM();
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zze("Configuration loss. Failed to serialize property filter. appId", zzati.zzfI(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.zzbvl);
        contentValues.put("property_name", zze2.zzbvB);
        contentValues.put("data", byArray);
        try {
            zzbum2 = this.getWritableDatabase();
            long l = zzbum2.insertWithOnConflict("property_filters", null, contentValues, 5);
            if (l == -1L) {
                this.zzJt().zzLa().zzj("Failed to insert property filter (got -1). appId", zzati.zzfI(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing property filter. appId", zzati.zzfI(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzauf.zzb>> zzS(String string, String string2) {
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzauf.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzbul zzbul2 = zzbul.zzad((byte[])byArray);
                zzauf.zzb zzb2 = new zzauf.zzb();
                try {
                    zzb2.zzb(zzbul2);
                }
                catch (IOException iOException) {
                    this.zzJt().zzLa().zze("Failed to merge filter. appId", zzati.zzfI(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzauf.zzb> arrayList = (ArrayList<zzauf.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzauf.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List<zzauf.zze>> zzT(String string, String string2) {
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzauf.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzbul zzbul2 = zzbul.zzad((byte[])byArray);
                zzauf.zze zze2 = new zzauf.zze();
                try {
                    zze2.zzb(zzbul2);
                }
                catch (IOException iOException) {
                    this.zzJt().zzLa().zze("Failed to merge filter", zzati.zzfI(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzauf.zze> arrayList = (ArrayList<zzauf.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzauf.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        zzac.zzdv((String)string);
        this.zznA();
        this.zzmq();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Database error querying filters. appId", zzati.zzfI(string), (Object)sQLiteException);
            return false;
        }
        int n = this.zzJv().zzfs(string);
        if (l <= (long)n) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object == null || !(object instanceof Integer)) {
                    return false;
                }
                arrayList.add(Integer.toString((Integer)object));
            }
        }
        object = String.valueOf(TextUtils.join((CharSequence)",", arrayList));
        String string2 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        int n2 = sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string2).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string2).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n)});
        return n2 > 0;
    }

    void zza(String string, int n, zzauh.zzf zzf2) {
        zzbum zzbum2;
        byte[] byArray;
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        zzac.zzw((Object)((Object)zzf2));
        try {
            int n2 = zzf2.zzacZ();
            byArray = new byte[n2];
            zzbum2 = zzbum.zzae((byte[])byArray);
            zzf2.zza(zzbum2);
            zzbum2.zzacM();
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zze("Configuration loss. Failed to serialize filter results. appId", zzati.zzfI(string), iOException);
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("current_results", byArray);
        try {
            zzbum2 = this.getWritableDatabase();
            long l = zzbum2.insertWithOnConflict("audience_filter_values", null, contentValues, 5);
            if (l == -1L) {
                this.zzJt().zzLa().zzj("Failed to insert filter results (got -1). appId", zzati.zzfI(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing filter results. appId", zzati.zzfI(string), (Object)sQLiteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, zzauh.zzf> zzfC(String string) {
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzbul zzbul2 = zzbul.zzad((byte[])byArray);
                zzauh.zzf zzf2 = new zzauh.zzf();
                try {
                    zzf2.zzb(zzbul2);
                }
                catch (IOException iOException) {
                    this.zzJt().zzLa().zzd("Failed to merge filter results. appId, audienceId, error", zzati.zzfI(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzf2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    void zzfD(String string) {
        this.zznA();
        this.zzmq();
        zzac.zzdv((String)string);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("apps", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("event_filters", "app_id=?", stringArray);
            n += sQLiteDatabase.delete("property_filters", "app_id=?", stringArray);
            if ((n += sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray)) > 0) {
                this.zzJt().zzLg().zze("Deleted application data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error deleting application data. appId, error", zzati.zzfI(string), (Object)sQLiteException);
        }
    }

    @WorkerThread
    void zza(ContentValues contentValues, String string, Object object) {
        zzac.zzdv((String)string);
        zzac.zzw((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
        } else if (object instanceof Long) {
            contentValues.put(string, (Long)object);
        } else if (object instanceof Double) {
            contentValues.put(string, (Double)object);
        } else {
            throw new IllegalArgumentException("Invalid value type");
        }
    }

    @WorkerThread
    @TargetApi(value=11)
    static int zza(Cursor cursor, int n) {
        int n2;
        if (Build.VERSION.SDK_INT >= 11) {
            return cursor.getType(n);
        }
        SQLiteCursor sQLiteCursor = (SQLiteCursor)cursor;
        CursorWindow cursorWindow = sQLiteCursor.getWindow();
        if (cursorWindow.isNull(n2 = cursor.getPosition(), n)) {
            return 0;
        }
        if (cursorWindow.isLong(n2, n)) {
            return 1;
        }
        if (cursorWindow.isFloat(n2, n)) {
            return 2;
        }
        if (cursorWindow.isString(n2, n)) {
            return 3;
        }
        if (cursorWindow.isBlob(n2, n)) {
            return 4;
        }
        return -1;
    }

    @WorkerThread
    Object zzb(Cursor cursor, int n) {
        int n2 = zzasu.zza(cursor, n);
        switch (n2) {
            case 0: {
                this.zzJt().zzLa().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzJt().zzLa().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzJt().zzLa().zzj("Loaded invalid unknown value type, ignoring it", n2);
        return null;
    }

    @WorkerThread
    public long zzKK() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    public long zzfE(String string) {
        zzac.zzdv((String)string);
        this.zzmq();
        this.zznA();
        return this.zzU(string, "first_open_count");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected long zzU(String string, String string2) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        this.zzmq();
        this.zznA();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            long l2;
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                l2 = sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5);
                if (l2 == -1L) {
                    this.zzJt().zzLa().zze("Failed to insert column (got -1). appId", zzati.zzfI(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            l2 = sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string});
            if (l2 == 0L) {
                this.zzJt().zzLa().zze("Failed to update column (got 0). appId", zzati.zzfI(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zzd("Error inserting column. appId", zzati.zzfI(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public long zzKL() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public long zza(zzauh.zze zze2) throws IOException {
        byte[] byArray;
        this.zzmq();
        this.zznA();
        zzac.zzw((Object)((Object)zze2));
        zzac.zzdv((String)zze2.zzaR);
        try {
            int n = zze2.zzacZ();
            byArray = new byte[n];
            zzbum zzbum2 = zzbum.zzae((byte[])byArray);
            zze2.zza(zzbum2);
            zzbum2.zzacM();
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zze("Data loss. Failed to serialize event metadata. appId", zzati.zzfI(zze2.zzaR), iOException);
            throw iOException;
        }
        long l = this.zzJp().zzz(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zze2.zzaR);
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            sQLiteDatabase.insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing raw event metadata. appId", zzati.zzfI(zze2.zzaR), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public boolean zzKM() {
        long l = this.zzb("select count(1) > 0 from raw_events", (String[])null);
        return l != 0L;
    }

    public boolean zzKN() {
        long l = this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null);
        return l != 0L;
    }

    public void zzG(List<Long> list) {
        zzac.zzw(list);
        this.zzmq();
        this.zznA();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzJt().zzLa().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public void zzfF(String string) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string, string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Failed to remove unused event metadata. appId", zzati.zzfI(string), (Object)sQLiteException);
        }
    }

    public long zzfG(String string) {
        zzac.zzdv((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzam(long l) {
        this.zzmq();
        this.zznA();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzJt().zzLg().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zzKO() {
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string, long l, long l2, zzb zzb2) {
        zzac.zzw((Object)zzb2);
        this.zzmq();
        this.zznA();
        try (Cursor cursor = null;){
            String[] stringArray;
            String string2;
            String string3;
            String string4;
            Object[] objectArray;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if (TextUtils.isEmpty((CharSequence)string)) {
                objectArray = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l)} : new String[]{String.valueOf(l)};
                string4 = l2 != -1L ? "rowid <= ? and " : "";
                cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), objectArray);
                if (!cursor.moveToFirst()) {
                    return;
                }
                string = cursor.getString(0);
                string3 = cursor.getString(1);
                cursor.close();
            } else {
                objectArray = l2 != -1L ? new String[]{string, String.valueOf(l2)} : new String[]{string};
                string4 = l2 != -1L ? " and rowid <= ?" : "";
                cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), objectArray);
                if (!cursor.moveToFirst()) {
                    return;
                }
                string3 = cursor.getString(0);
                cursor.close();
            }
            cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string, string3}, null, null, "rowid", "2");
            if (!cursor.moveToFirst()) {
                this.zzJt().zzLa().zzj("Raw event metadata record is missing. appId", zzati.zzfI(string));
                return;
            }
            objectArray = cursor.getBlob(0);
            string4 = zzbul.zzad((byte[])objectArray);
            zzauh.zze zze2 = new zzauh.zze();
            try {
                zze2.zzb((zzbul)string4);
            }
            catch (IOException iOException) {
                this.zzJt().zzLa().zze("Data loss. Failed to merge raw event metadata. appId", zzati.zzfI(string), iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            if (cursor.moveToNext()) {
                this.zzJt().zzLc().zzj("Get multiple raw event metadata records, expected one. appId", zzati.zzfI(string));
            }
            cursor.close();
            zzb2.zzb(zze2);
            if (l2 != -1L) {
                string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                stringArray = new String[]{string, string3, String.valueOf(l2)};
            } else {
                string2 = "app_id = ? and metadata_fingerprint = ?";
                stringArray = new String[]{string, string3};
            }
            cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
            if (!cursor.moveToFirst()) {
                this.zzJt().zzLc().zzj("Raw event data disappeared while in transaction. appId", zzati.zzfI(string));
                return;
            }
            do {
                long l3 = cursor.getLong(0);
                objectArray = cursor.getBlob(3);
                string4 = zzbul.zzad((byte[])objectArray);
                zzauh.zzb zzb3 = new zzauh.zzb();
                try {
                    zzb3.zzb((zzbul)string4);
                }
                catch (IOException iOException) {
                    this.zzJt().zzLa().zze("Data loss. Failed to merge raw event. appId", zzati.zzfI(string), iOException);
                    continue;
                }
                zzb3.name = cursor.getString(1);
                zzb3.zzbvW = cursor.getLong(2);
                if (zzb2.zza(l3, zzb3)) continue;
                return;
            } while (cursor.moveToNext());
        }
    }

    public void zza(zzasx zzasx2, long l, boolean bl) {
        Object object;
        zzauh.zzc zzc2;
        this.zzmq();
        this.zznA();
        zzac.zzw((Object)zzasx2);
        zzac.zzdv((String)zzasx2.zzVQ);
        zzauh.zzb zzb2 = new zzauh.zzb();
        zzb2.zzbvX = zzasx2.zzbqH;
        zzb2.zzbvV = new zzauh.zzc[zzasx2.zzbqI.size()];
        int n = 0;
        for (String string : zzasx2.zzbqI) {
            zzc2 = new zzauh.zzc();
            zzb2.zzbvV[n++] = zzc2;
            zzc2.name = string;
            Object object2 = zzasx2.zzbqI.get(string);
            this.zzJp().zza(zzc2, object2);
        }
        try {
            int n2 = zzb2.zzacZ();
            object = new byte[n2];
            zzc2 = zzbum.zzae((byte[])object);
            zzb2.zza((zzbum)zzc2);
            zzc2.zzacM();
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zze("Data loss. Failed to serialize event params/data. appId", zzati.zzfI(zzasx2.zzVQ), iOException);
            return;
        }
        this.zzJt().zzLg().zze("Saving event, name, data size", zzasx2.mName, ((Object)object).length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzasx2.zzVQ);
        contentValues.put("name", zzasx2.mName);
        contentValues.put("timestamp", Long.valueOf(zzasx2.zzavX));
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("data", (byte[])object);
        contentValues.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            zzc2 = this.getWritableDatabase();
            long l2 = zzc2.insert("raw_events", null, contentValues);
            if (l2 == -1L) {
                this.zzJt().zzLa().zzj("Failed to insert raw event (got -1). appId", zzati.zzfI(zzasx2.zzVQ));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzJt().zzLa().zze("Error storing raw event. appId", zzati.zzfI(zzasx2.zzVQ), (Object)sQLiteException);
        }
    }

    private boolean zzKP() {
        return this.getContext().getDatabasePath(this.zznV()).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static boolean zza(zzati zzati2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzati2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    static void zza(zzati zzati2, SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
        if (zzati2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzasu.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (set.remove(entry.getKey())) continue;
                sQLiteDatabase.execSQL((String)entry.getValue());
            }
        }
        if (!set.isEmpty()) {
            zzati2.zzLc().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzati zzati2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
        if (zzati2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzasu.zza(zzati2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzasu.zza(zzati2, sQLiteDatabase, string, string3, map);
        }
        catch (SQLiteException sQLiteException) {
            zzati2.zzLa().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzati zzati2, SQLiteDatabase sQLiteDatabase) {
        if (zzati2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (Build.VERSION.SDK_INT >= 9) {
            File file = new File(sQLiteDatabase.getPath());
            if (!file.setReadable(false, false)) {
                zzati2.zzLc().log("Failed to turn off database read permission");
            }
            if (!file.setWritable(false, false)) {
                zzati2.zzLc().log("Failed to turn off database write permission");
            }
            if (!file.setReadable(true, true)) {
                zzati2.zzLc().log("Failed to turn on database read permission for owner");
            }
            if (!file.setWritable(true, true)) {
                zzati2.zzLc().log("Failed to turn on database write permission for owner");
            }
        }
    }

    static {
        zzbqp.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zzbqp.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zzbqp.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zzbqp.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zzbqp.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        zzbqp.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        zzbqp.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        zzbqp.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        zzbqp.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        zzbqp.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        zzbqp.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        zzbqp.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        zzbqp.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        zzbqp.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        zzbqp.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        zzbqp.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
        zzbqp.put("daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;");
        zzbqp.put("health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;");
        zzbqq = new ArrayMap(1);
        zzbqq.put("realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;");
        zzbqr = new ArrayMap(1);
        zzbqr.put("has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;");
        zzbqs = new ArrayMap(1);
        zzbqs.put("previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;");
    }

    private class zzc
    extends SQLiteOpenHelper {
        zzc(Context context, String string) {
            super(context, string, null, 1);
        }

        @WorkerThread
        public SQLiteDatabase getWritableDatabase() {
            if (!zzasu.this.zzbqu.zzz(zzasu.this.zzJv().zzKg())) {
                throw new SQLiteException("Database open failed");
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                zzasu.this.zzbqu.start();
                zzasu.this.zzJt().zzLa().log("Opening the database failed, dropping and recreating it");
                String string = zzasu.this.zznV();
                if (!zzasu.this.getContext().getDatabasePath(string).delete()) {
                    zzasu.this.zzJt().zzLa().zzj("Failed to delete corrupted db file", string);
                }
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzasu.this.zzbqu.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzasu.this.zzJt().zzLa().zzj("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        @WorkerThread
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "events", "CREATE TABLE IF NOT EXISTS events ( app_id TEXT NOT NULL, name TEXT NOT NULL, lifetime_count INTEGER NOT NULL, current_bundle_count INTEGER NOT NULL, last_fire_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,lifetime_count,current_bundle_count,last_fire_timestamp", null);
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "user_attributes", "CREATE TABLE IF NOT EXISTS user_attributes ( app_id TEXT NOT NULL, name TEXT NOT NULL, set_timestamp INTEGER NOT NULL, value BLOB NOT NULL, PRIMARY KEY (app_id, name)) ;", "app_id,name,set_timestamp,value", null);
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "apps", "CREATE TABLE IF NOT EXISTS apps ( app_id TEXT NOT NULL, app_instance_id TEXT, gmp_app_id TEXT, resettable_device_id_hash TEXT, last_bundle_index INTEGER NOT NULL, last_bundle_end_timestamp INTEGER NOT NULL, PRIMARY KEY (app_id)) ;", "app_id,app_instance_id,gmp_app_id,resettable_device_id_hash,last_bundle_index,last_bundle_end_timestamp", zzbqp);
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "queue", "CREATE TABLE IF NOT EXISTS queue ( app_id TEXT NOT NULL, bundle_end_timestamp INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,bundle_end_timestamp,data", zzbqr);
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "raw_events_metadata", "CREATE TABLE IF NOT EXISTS raw_events_metadata ( app_id TEXT NOT NULL, metadata_fingerprint INTEGER NOT NULL, metadata BLOB NOT NULL, PRIMARY KEY (app_id, metadata_fingerprint));", "app_id,metadata_fingerprint,metadata", null);
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "raw_events", "CREATE TABLE IF NOT EXISTS raw_events ( app_id TEXT NOT NULL, name TEXT NOT NULL, timestamp INTEGER NOT NULL, metadata_fingerprint INTEGER NOT NULL, data BLOB NOT NULL);", "app_id,name,timestamp,metadata_fingerprint,data", zzbqq);
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "event_filters", "CREATE TABLE IF NOT EXISTS event_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, event_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, event_name, audience_id, filter_id));", "app_id,audience_id,filter_id,event_name,data", null);
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "property_filters", "CREATE TABLE IF NOT EXISTS property_filters ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, filter_id INTEGER NOT NULL, property_name TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (app_id, property_name, audience_id, filter_id));", "app_id,audience_id,filter_id,property_name,data", null);
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "audience_filter_values", "CREATE TABLE IF NOT EXISTS audience_filter_values ( app_id TEXT NOT NULL, audience_id INTEGER NOT NULL, current_results BLOB, PRIMARY KEY (app_id, audience_id));", "app_id,audience_id,current_results", null);
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase, "app2", "CREATE TABLE IF NOT EXISTS app2 ( app_id TEXT NOT NULL, first_open_count INTEGER NOT NULL, PRIMARY KEY (app_id));", "app_id,first_open_count", zzbqs);
        }

        @WorkerThread
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzasu.zza(zzasu.this.zzJt(), sQLiteDatabase);
        }

        @WorkerThread
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }

    static interface zzb {
        public void zzb(zzauh.zze var1);

        public boolean zza(long var1, zzauh.zzb var3);
    }

    public static class zza {
        long zzbqv;
        long zzbqw;
        long zzbqx;
        long zzbqy;
        long zzbqz;
    }
}

