/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.os.Parcel;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.safeparcel.zzb;
import com.google.android.gms.internal.zzasu;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzaub;
import java.util.ArrayList;
import java.util.List;

public class zzatg
extends zzats {
    private final zza zzbrD = new zza(this.getContext(), this.zznV());
    private boolean zzbrE;

    zzatg(zzatp zzatp2) {
        super(zzatp2);
    }

    @Override
    protected void zzmr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    @WorkerThread
    private boolean zza(int n, byte[] byArray) {
        this.zzJe();
        this.zzmq();
        if (this.zzbrE) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        this.zzJv().zzKt();
        for (int i = 0; i < 5; ++i) {
            try (SQLiteDatabase sQLiteDatabase = null;){
                sQLiteDatabase = this.getWritableDatabase();
                if (sQLiteDatabase == null) {
                    this.zzbrE = true;
                    return false;
                }
                sQLiteDatabase.beginTransaction();
                long l = 0L;
                Cursor cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                if (cursor != null && cursor.moveToFirst()) {
                    l = cursor.getLong(0);
                }
                if (l >= 100000L) {
                    this.zzJt().zzLa().log("Data loss, local db full");
                    long l2 = 100000L - l + 1L;
                    long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                    if (l3 != l2) {
                        this.zzJt().zzLa().zzd("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                    }
                }
                sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                return true;
            }
        }
        this.zzJt().zzLc().log("Failed to write entry to local database");
        return false;
    }

    public boolean zza(zzatb zzatb2) {
        if (Build.VERSION.SDK_INT < 11) {
            return false;
        }
        Parcel parcel = Parcel.obtain();
        zzatb2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            this.zzJt().zzLc().log("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zza(0, byArray);
    }

    public boolean zza(zzaub zzaub2) {
        if (Build.VERSION.SDK_INT < 11) {
            return false;
        }
        Parcel parcel = Parcel.obtain();
        zzaub2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            this.zzJt().zzLc().log("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(1, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    public List<com.google.android.gms.common.internal.safeparcel.zza> zzls(int n) {
        this.zzmq();
        this.zzJe();
        if (Build.VERSION.SDK_INT < 11) {
            return null;
        }
        if (this.zzbrE) {
            return null;
        }
        ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList = new ArrayList<com.google.android.gms.common.internal.safeparcel.zza>();
        if (!this.zzKP()) {
            return arrayList;
        }
        int n2 = 5;
        for (int i = 0; i < 5; ++i) {
            try (SQLiteDatabase sQLiteDatabase = null;){
                Object object;
                int n3;
                sQLiteDatabase = this.getWritableDatabase();
                if (sQLiteDatabase == null) {
                    this.zzbrE = true;
                    return null;
                }
                sQLiteDatabase.beginTransaction();
                Cursor cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(n));
                long l = -1L;
                while (cursor.moveToNext()) {
                    com.google.android.gms.common.internal.safeparcel.zza zza2;
                    Parcel parcel;
                    l = cursor.getLong(0);
                    n3 = cursor.getInt(1);
                    object = cursor.getBlob(2);
                    if (n3 == 0) {
                        parcel = Parcel.obtain();
                        try {
                            parcel.unmarshall(object, 0, ((byte[])object).length);
                            parcel.setDataPosition(0);
                            zza2 = (zzatb)((Object)zzatb.CREATOR.createFromParcel(parcel));
                        }
                        catch (zzb.zza zza3) {
                            this.zzJt().zzLa().log("Failed to load event from local database");
                            continue;
                        }
                        finally {
                            parcel.recycle();
                            continue;
                        }
                        if (zza2 == null) continue;
                        arrayList.add(zza2);
                        continue;
                    }
                    if (n3 == 1) {
                        parcel = Parcel.obtain();
                        zza2 = null;
                        try {
                            parcel.unmarshall(object, 0, ((byte[])object).length);
                            parcel.setDataPosition(0);
                            zza2 = (zzaub)((Object)zzaub.CREATOR.createFromParcel(parcel));
                        }
                        catch (zzb.zza zza4) {
                            this.zzJt().zzLa().log("Failed to load user property from local database");
                        }
                        finally {
                            parcel.recycle();
                        }
                        if (zza2 == null) continue;
                        arrayList.add(zza2);
                        continue;
                    }
                    this.zzJt().zzLa().log("Unknown record type in local database");
                }
                cursor.close();
                n3 = sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)});
                if (n3 < arrayList.size()) {
                    this.zzJt().zzLa().log("Fewer entries removed from local database than expected");
                }
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                object = arrayList;
                return object;
            }
        }
        this.zzJt().zzLc().log("Failed to read events from database in reasonable time");
        return null;
    }

    @WorkerThread
    SQLiteDatabase getWritableDatabase() {
        if (Build.VERSION.SDK_INT < 11) {
            return null;
        }
        if (this.zzbrE) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zzbrD.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzbrE = true;
            return null;
        }
        return sQLiteDatabase;
    }

    boolean zzKP() {
        return this.getContext().getDatabasePath(this.zznV()).exists();
    }

    String zznV() {
        return this.zzJv().zzKj();
    }

    @TargetApi(value=11)
    private class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        @WorkerThread
        public SQLiteDatabase getWritableDatabase() {
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                    throw sQLiteException;
                }
                zzatg.this.zzJt().zzLa().log("Opening the local database failed, dropping and recreating it");
                String string = zzatg.this.zznV();
                if (!zzatg.this.getContext().getDatabasePath(string).delete()) {
                    zzatg.this.zzJt().zzLa().zzj("Failed to delete corrupted local db file", string);
                }
                try {
                    return super.getWritableDatabase();
                }
                catch (SQLiteException sQLiteException2) {
                    zzatg.this.zzJt().zzLa().zzj("Failed to open local database. Events will bypass local storage", (Object)sQLiteException2);
                    return null;
                }
            }
        }

        @WorkerThread
        public void onOpen(SQLiteDatabase sQLiteDatabase) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            zzasu.zza(zzatg.this.zzJt(), sQLiteDatabase, "messages", "create table if not exists messages ( type INTEGER NOT NULL, entry BLOB NOT NULL)", "type,entry", null);
        }

        @WorkerThread
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            zzasu.zza(zzatg.this.zzJt(), sQLiteDatabase);
        }

        @WorkerThread
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        }
    }
}

