/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzati;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaud;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.measurement.AppMeasurement;

public final class zzatm {
    private final zza zzbsC;

    public zzatm(zza zza2) {
        zzac.zzw((Object)zza2);
        this.zzbsC = zza2;
    }

    public static boolean zzi(Context context, boolean bl) {
        zzac.zzw((Object)context);
        return zzaue.zza(context, bl ? "com.google.android.gms.measurement.PackageMeasurementReceiver" : "com.google.android.gms.measurement.AppMeasurementReceiver", false);
    }

    @MainThread
    public void onReceive(final Context context, Intent intent) {
        final zzatp zzatp2 = zzatp.zzbu(context);
        final zzati zzati2 = zzatp2.zzJt();
        if (intent == null) {
            zzati2.zzLc().log("Receiver called with null intent");
            return;
        }
        zzatp2.zzJv().zzKk();
        String string = intent.getAction();
        zzati2.zzLg().zzj("Local receiver got", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzatx.zzj(context, false);
            Intent intent2 = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            this.zzbsC.doStartService(context, intent2);
        } else if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzati2.zzLg().log("Install referrer extras are null");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            final Bundle bundle = zzatp2.zzJp().zzu(uri);
            if (bundle == null) {
                zzati2.zzLg().log("No campaign defined in install referrer broadcast");
            } else {
                final long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzati2.zzLc().log("Install referrer is missing timestamp");
                }
                zzatp2.zzJs().zzm(new Runnable(this){

                    @Override
                    public void run() {
                        long l3 = 0L;
                        zzaud zzaud2 = zzatp2.zzJo().zzR(zzatp2.zzJj().zzjI(), "_fot");
                        if (zzaud2 != null && zzaud2.zzYe instanceof Long) {
                            l3 = (Long)zzaud2.zzYe;
                        }
                        long l2 = l;
                        if (l3 > 0L && (l2 >= l3 || l2 <= 0L)) {
                            l2 = l3 - 1L;
                        }
                        if (l2 > 0L) {
                            bundle.putLong("click_timestamp", l2);
                        }
                        AppMeasurement.getInstance(context).logEventInternal("auto", "_cmp", bundle);
                        zzati2.zzLg().log("Install campaign recorded");
                    }
                });
            }
        }
    }

    public static interface zza {
        public void doStartService(Context var1, Intent var2);
    }
}

