/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class zzatv
extends zzats {
    protected zza zzbul;
    private volatile AppMeasurement.zzf zzbum;
    private AppMeasurement.zzf zzbun;
    private long zzbuo;
    private final Map<Activity, zza> zzbup = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zzd> zzbuq = new CopyOnWriteArrayList();
    private boolean zzbur;
    private AppMeasurement.zzf zzbus;
    private String zzbut;

    public zzatv(zzatp zzatp2) {
        super(zzatp2);
    }

    @Override
    protected void zzmr() {
    }

    @WorkerThread
    public zza zzLU() {
        this.zznA();
        this.zzmq();
        return this.zzbul;
    }

    @MainThread
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        boolean bl;
        if (Build.VERSION.SDK_INT < 14) {
            this.zzJt().zzLd().log("Screen engagement recording is only available at API level 14+");
            return;
        }
        if (activity == null) {
            this.zzJt().zzLc().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        if (!this.zzJs().zzbd()) {
            this.zzJt().zzLc().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzbur) {
            this.zzJt().zzLc().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzbum == null) {
            this.zzJt().zzLc().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzbup.get(activity) == null) {
            this.zzJt().zzLc().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzatv.zzfV(activity.getClass().getCanonicalName());
        }
        boolean bl2 = this.zzbum.zzbpA.equals(string2);
        boolean bl3 = bl = this.zzbum.zzbpz == null && string == null || this.zzbum.zzbpz != null && this.zzbum.zzbpz.equals(string);
        if (bl2 && bl) {
            this.zzJt().zzLd().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() < 1 || string.length() > this.zzJv().zzJX())) {
            this.zzJt().zzLc().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() < 1 || string2.length() > this.zzJv().zzJX())) {
            this.zzJt().zzLc().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        this.zzJt().zzLg().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zza zza2 = new zza(string, string2, this.zzJp().zzMi());
        this.zzbup.put(activity, zza2);
        this.zza(activity, zza2, true);
    }

    public AppMeasurement.zzf zzLV() {
        this.zzJe();
        AppMeasurement.zzf zzf2 = this.zzbum;
        if (zzf2 == null) {
            return null;
        }
        return new AppMeasurement.zzf(zzf2);
    }

    @MainThread
    public void registerOnScreenChangeCallback(@NonNull AppMeasurement.zzd zzd2) {
        this.zzJe();
        if (zzd2 == null) {
            this.zzJt().zzLc().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzbuq.remove(zzd2);
        this.zzbuq.add(zzd2);
    }

    @MainThread
    public void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zzd zzd2) {
        this.zzJe();
        this.zzbuq.remove(zzd2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    private void zza(Activity activity, zza zza2, final boolean bl) {
        AppMeasurement.zzf zzf2 = null;
        if (this.zzbum != null) {
            zzf2 = this.zzbum;
        } else if (this.zzbun != null && Math.abs(this.zznq().elapsedRealtime() - this.zzbuo) < 1000L) {
            zzf2 = this.zzbun;
        }
        AppMeasurement.zzf zzf3 = null;
        if (zzf2 != null) {
            zzf3 = new AppMeasurement.zzf(zzf2);
        }
        boolean bl2 = true;
        this.zzbur = true;
        try {
            for (AppMeasurement.zzd zzd2 : this.zzbuq) {
                try {
                    bl2 &= zzd2.zza(zzf3, zza2);
                }
                catch (Exception exception) {
                    this.zzJt().zzLa().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            this.zzJt().zzLa().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzbur = false;
        }
        if (bl2) {
            if (zza2.zzbpA == null) {
                zza2.zzbpA = zzatv.zzfV(activity.getClass().getCanonicalName());
            }
            final zza zza3 = new zza(zza2);
            this.zzbun = this.zzbum;
            this.zzbuo = this.zznq().elapsedRealtime();
            this.zzbum = zza3;
            this.zzJs().zzm(new Runnable(){

                @Override
                public void run() {
                    if (bl && zzatv.this.zzbul != null) {
                        zzatv.this.zza(zzatv.this.zzbul);
                    }
                    zzatv.this.zzbul = zza3;
                    zzatv.this.zzJl().zza(zza3);
                }
            });
        }
    }

    @WorkerThread
    private void zza(@NonNull zza zza2) {
        this.zzJg().zzV(this.zznq().elapsedRealtime());
        if (this.zzJr().zzaJ(zza2.zzbuy)) {
            zza2.zzbuy = false;
        }
    }

    public static void zza(AppMeasurement.zzf zzf2, Bundle bundle) {
        if (bundle != null && zzf2 != null && !bundle.containsKey("_sc")) {
            if (zzf2.zzbpz != null) {
                bundle.putString("_sn", zzf2.zzbpz);
            }
            bundle.putString("_sc", zzf2.zzbpA);
            bundle.putLong("_si", zzf2.zzbpB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppMeasurement.zzf zzfU(String string) {
        zzatv zzatv2 = this;
        synchronized (zzatv2) {
            if (this.zzbus == null || this.zzbut == null || !this.zzbut.equals(string)) {
                return null;
            }
            return this.zzbus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(String string, AppMeasurement.zzf zzf2) {
        this.zzmq();
        zzatv zzatv2 = this;
        synchronized (zzatv2) {
            if (this.zzbut == null || this.zzbut.equals(string) || zzf2 != null) {
                this.zzbut = string;
                this.zzbus = zzf2;
            }
        }
    }

    static String zzfV(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    zza zzv(@NonNull Activity activity) {
        zzac.zzw((Object)activity);
        zza zza2 = this.zzbup.get(activity);
        if (zza2 == null) {
            String string = zzatv.zzfV(activity.getClass().getCanonicalName());
            zza2 = new zza(null, string, this.zzJp().zzMi());
            this.zzbup.put(activity, zza2);
        }
        return zza2;
    }

    @MainThread
    public void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.firebase.analytics.screen_service");
        if (bundle2 == null) {
            return;
        }
        zza zza2 = this.zzv(activity);
        zza2.zzbpB = bundle2.getLong("id");
        zza2.zzbpz = bundle2.getString("name");
        zza2.zzbpA = bundle2.getString("referrer_name");
    }

    @MainThread
    public void onActivityResumed(Activity activity) {
        zza zza2 = this.zzv(activity);
        this.zza(activity, zza2, false);
        this.zzJg().zzJc();
    }

    @MainThread
    public void onActivityPaused(Activity activity) {
        final zza zza2 = this.zzv(activity);
        this.zzbun = this.zzbum;
        this.zzbuo = this.zznq().elapsedRealtime();
        this.zzbum = null;
        this.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatv.this.zza(zza2);
                zzatv.this.zzbul = null;
                zzatv.this.zzJl().zza((AppMeasurement.zzf)null);
            }
        });
    }

    @MainThread
    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zza zza2 = this.zzbup.get(activity);
        if (zza2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zza2.zzbpB);
        bundle2.putString("name", zza2.zzbpz);
        bundle2.putString("referrer_name", zza2.zzbpA);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public void onActivityDestroyed(Activity activity) {
        this.zzbup.remove(activity);
    }

    static class zza
    extends AppMeasurement.zzf {
        public boolean zzbuy;

        public zza(String string, String string2, long l) {
            this.zzbpz = string;
            this.zzbpA = string2;
            this.zzbpB = l;
            this.zzbuy = false;
        }

        public zza(zza zza2) {
            this.zzbpz = zza2.zzbpz;
            this.zzbpA = zza2.zzbpA;
            this.zzbpB = zza2.zzbpB;
            this.zzbuy = zza2.zzbuy;
        }
    }
}

