/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteException;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzatc;
import com.google.android.gms.internal.zzatd;
import com.google.android.gms.internal.zzatf;
import com.google.android.gms.internal.zzatg;
import com.google.android.gms.internal.zzati;
import com.google.android.gms.internal.zzatj;
import com.google.android.gms.internal.zzatl;
import com.google.android.gms.internal.zzatm;
import com.google.android.gms.internal.zzatn;
import com.google.android.gms.internal.zzato;
import com.google.android.gms.internal.zzatq;
import com.google.android.gms.internal.zzatu;
import com.google.android.gms.internal.zzatv;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaty;
import com.google.android.gms.internal.zzatz;
import com.google.android.gms.internal.zzaua;
import com.google.android.gms.internal.zzaub;
import com.google.android.gms.internal.zzauc;
import com.google.android.gms.internal.zzaud;
import com.google.android.gms.internal.zzaug;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzaui;
import com.google.android.gms.internal.zzauj;
import com.google.android.gms.internal.zzauk;
import com.google.android.gms.internal.zzaul;
import com.google.android.gms.internal.zzaum;
import com.google.android.gms.internal.zzaun;
import com.google.android.gms.internal.zzaup;
import com.google.android.gms.internal.zzauq;
import com.google.android.gms.internal.zzaus;
import com.google.android.gms.internal.zzaut;
import com.google.android.gms.internal.zzauv;
import com.google.android.gms.internal.zzauw;
import com.google.android.gms.internal.zzbxm;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzaue {
    private static volatile zzaue zzbud;
    private final Context mContext;
    private final zzati zzbue;
    private final zzaua zzbuf;
    private final zzatx zzbug;
    private final zzaud zzbuh;
    private final zzaun zzbui;
    private final zzauc zzbuj;
    private final AppMeasurement zzbuk;
    private final FirebaseAnalytics zzbul;
    private final zzaut zzbum;
    private final zzatj zzbun;
    private final zzatv zzbuo;
    private final zzaty zzbup;
    private final zze zzuP;
    private final zzauk zzbuq;
    private final zzaul zzbur;
    private final zzatl zzbus;
    private final zzauj zzbut;
    private final zzatu zzbuu;
    private final zzatz zzbuv;
    private final zzaup zzbuw;
    private final zzatf zzbux;
    private final zzatb zzbuy;
    private final boolean zzadP;
    private boolean zzbuz;
    private Boolean zzbuA;
    private long zzbuB;
    private FileLock zzbuC;
    private FileChannel zzbuD;
    private List<Long> zzbuE;
    private int zzbuF;
    private int zzbuG;
    private long zzbuH;
    protected long zzbuI;

    zzaue(zzaui zzaui2) {
        zzatb zzatb2;
        zzac.zzw((Object)zzaui2);
        this.mContext = zzaui2.mContext;
        this.zzbuH = -1L;
        this.zzuP = zzaui2.zzn(this);
        this.zzbue = zzaui2.zza(this);
        zzaua zzaua2 = zzaui2.zzb(this);
        zzaua2.initialize();
        this.zzbuf = zzaua2;
        zzatx zzatx2 = zzaui2.zzc(this);
        zzatx2.initialize();
        this.zzbug = zzatx2;
        this.zzKk().zzMb().zzj("App measurement is starting up, version", this.zzKm().zzKu());
        this.zzKm().zzLf();
        this.zzKk().zzMb().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzaut zzaut2 = zzaui2.zzj(this);
        zzaut2.initialize();
        this.zzbum = zzaut2;
        zzatl zzatl2 = zzaui2.zzq(this);
        zzatl2.initialize();
        this.zzbus = zzatl2;
        zzatu zzatu2 = zzaui2.zzr(this);
        zzatu2.initialize();
        this.zzbuu = zzatu2;
        this.zzKm().zzLf();
        Object object = zzatu2.zzke();
        if (this.zzKg().zzge((String)object)) {
            this.zzKk().zzMb().log("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
        } else {
            String string = String.valueOf(object);
            this.zzKk().zzMb().log(string.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app "));
        }
        this.zzKk().zzMc().log("Debug-level message logging enabled");
        object = zzaui2.zzk(this);
        ((zzauh)object).initialize();
        this.zzbun = object;
        zzatv zzatv2 = zzaui2.zzl(this);
        zzatv2.initialize();
        this.zzbuo = zzatv2;
        zzatf zzatf2 = zzaui2.zzu(this);
        zzatf2.initialize();
        this.zzbux = zzatf2;
        this.zzbuy = zzatb2 = zzaui2.zzv(this);
        zzaty zzaty2 = zzaui2.zzm(this);
        zzaty2.initialize();
        this.zzbup = zzaty2;
        zzauk zzauk2 = zzaui2.zzo(this);
        zzauk2.initialize();
        this.zzbuq = zzauk2;
        zzaul zzaul2 = zzaui2.zzp(this);
        zzaul2.initialize();
        this.zzbur = zzaul2;
        zzauj zzauj2 = zzaui2.zzi(this);
        zzauj2.initialize();
        this.zzbut = zzauj2;
        zzaup zzaup2 = zzaui2.zzt(this);
        zzaup2.initialize();
        this.zzbuw = zzaup2;
        this.zzbuv = zzaui2.zzs(this);
        this.zzbuk = zzaui2.zzh(this);
        this.zzbul = zzaui2.zzg(this);
        zzaun zzaun2 = zzaui2.zze(this);
        zzaun2.initialize();
        this.zzbui = zzaun2;
        zzauc zzauc2 = zzaui2.zzf(this);
        zzauc2.initialize();
        this.zzbuj = zzauc2;
        zzaud zzaud2 = zzaui2.zzd(this);
        zzaud2.initialize();
        this.zzbuh = zzaud2;
        if (this.zzbuF != this.zzbuG) {
            this.zzKk().zzLX().zze("Not all components initialized", this.zzbuF, this.zzbuG);
        }
        this.zzadP = true;
        this.zzbue.zzLf();
        if (this.mContext.getApplicationContext() instanceof Application) {
            this.zzJZ().zzMP();
        } else {
            this.zzKk().zzLZ().log("Application context is not an Application");
        }
        this.zzbuh.zzm(new Runnable(){

            @Override
            public void run() {
                zzaue.this.start();
            }
        });
    }

    void zzob() {
        if (!this.zzadP) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected boolean zzMs() {
        this.zzob();
        this.zzmR();
        if (this.zzbuA == null || this.zzbuB == 0L || this.zzbuA != null && !this.zzbuA.booleanValue() && Math.abs(this.zznR().elapsedRealtime() - this.zzbuB) > 1000L) {
            this.zzbuB = this.zznR().elapsedRealtime();
            this.zzKm().zzLf();
            this.zzbuA = this.zzKg().zzbW("android.permission.INTERNET") && this.zzKg().zzbW("android.permission.ACCESS_NETWORK_STATE") && (zzadg.zzbi((Context)this.getContext()).zzzw() || zzaub.zzi(this.getContext(), false) && zzaum.zzj(this.getContext(), false));
            if (this.zzbuA.booleanValue()) {
                this.zzbuA = this.zzKg().zzga(this.zzKa().getGmpAppId());
            }
        }
        return this.zzbuA;
    }

    @WorkerThread
    protected void start() {
        this.zzmR();
        this.zzKf().zzLE();
        if (this.zzKl().zzbtd.get() == 0L) {
            this.zzKl().zzbtd.set(this.zznR().currentTimeMillis());
        }
        if (!this.zzMs()) {
            if (this.isEnabled()) {
                if (!this.zzKg().zzbW("android.permission.INTERNET")) {
                    this.zzKk().zzLX().log("App is missing INTERNET permission");
                }
                if (!this.zzKg().zzbW("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzKk().zzLX().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                this.zzKm().zzLf();
                if (!zzadg.zzbi((Context)this.getContext()).zzzw()) {
                    if (!zzaub.zzi(this.getContext(), false)) {
                        this.zzKk().zzLX().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzaum.zzj(this.getContext(), false)) {
                        this.zzKk().zzLX().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzKk().zzLX().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            this.zzKm().zzLf();
            if (!TextUtils.isEmpty((CharSequence)this.zzKa().getGmpAppId())) {
                String string = this.zzKl().zzMj();
                if (string == null) {
                    this.zzKl().zzfI(this.zzKa().getGmpAppId());
                } else if (!string.equals(this.zzKa().getGmpAppId())) {
                    this.zzKk().zzMb().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzKl().zzMm();
                    this.zzbur.disconnect();
                    this.zzbur.zzoD();
                    this.zzKl().zzfI(this.zzKa().getGmpAppId());
                }
            }
            this.zzKm().zzLf();
            if (!TextUtils.isEmpty((CharSequence)this.zzKa().getGmpAppId())) {
                this.zzJZ().zzMQ();
            }
        }
        this.zzMH();
    }

    public zzati zzKm() {
        return this.zzbue;
    }

    public zzaua zzKl() {
        this.zza((zzaug)this.zzbuf);
        return this.zzbuf;
    }

    public zzatx zzKk() {
        this.zza(this.zzbug);
        return this.zzbug;
    }

    public zzatx zzMt() {
        return this.zzbug != null && this.zzbug.isInitialized() ? this.zzbug : null;
    }

    public zzaud zzKj() {
        this.zza(this.zzbuh);
        return this.zzbuh;
    }

    public zzaun zzKi() {
        this.zza(this.zzbui);
        return this.zzbui;
    }

    public zzauc zzKh() {
        this.zza(this.zzbuj);
        return this.zzbuj;
    }

    zzaud zzMu() {
        return this.zzbuh;
    }

    public zzauj zzJZ() {
        this.zza(this.zzbut);
        return this.zzbut;
    }

    public AppMeasurement zzMv() {
        return this.zzbuk;
    }

    public FirebaseAnalytics zzMw() {
        return this.zzbul;
    }

    public zzaut zzKg() {
        this.zza((zzaug)this.zzbum);
        return this.zzbum;
    }

    public zzatj zzKf() {
        this.zza(this.zzbun);
        return this.zzbun;
    }

    public zzatv zzKe() {
        this.zza(this.zzbuo);
        return this.zzbuo;
    }

    public zzaty zzMx() {
        this.zza(this.zzbup);
        return this.zzbup;
    }

    public Context getContext() {
        return this.mContext;
    }

    public zze zznR() {
        return this.zzuP;
    }

    public zzauk zzKd() {
        this.zza(this.zzbuq);
        return this.zzbuq;
    }

    public zzaul zzKc() {
        this.zza(this.zzbur);
        return this.zzbur;
    }

    public zzatl zzKb() {
        this.zza(this.zzbus);
        return this.zzbus;
    }

    public zzatu zzKa() {
        this.zza(this.zzbuu);
        return this.zzbuu;
    }

    public zzatz zzMy() {
        if (this.zzbuv == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzbuv;
    }

    public zzaup zzMz() {
        this.zza(this.zzbuw);
        return this.zzbuw;
    }

    public zzatf zzJY() {
        this.zza(this.zzbux);
        return this.zzbux;
    }

    public zzatb zzJX() {
        this.zza(this.zzbuy);
        return this.zzbuy;
    }

    @WorkerThread
    public void zzmR() {
        this.zzKj().zzmR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzaue zzbM(Context context) {
        zzac.zzw((Object)context);
        zzac.zzw((Object)context.getApplicationContext());
        if (zzbud != null) return zzbud;
        Class<zzaue> clazz = zzaue.class;
        synchronized (zzaue.class) {
            if (zzbud != null) return zzbud;
            zzaui zzaui2 = new zzaui(context);
            zzbud = zzaui2.zzMO();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbud;
        }
    }

    FileChannel zzMA() {
        return this.zzbuD;
    }

    private void zza(zzauh zzauh2) {
        if (zzauh2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzauh2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzaug zzaug2) {
        if (zzaug2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    void zzMB() {
        this.zzmR();
        this.zzob();
        if (this.zzML() && this.zzMC()) {
            int n = this.zza(this.zzMA());
            int n2 = this.zzKa().zzLW();
            this.zzy(n, n2);
        }
    }

    @WorkerThread
    boolean zzMC() {
        this.zzmR();
        String string = this.zzbun.zzow();
        File file = this.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzbuD = new RandomAccessFile(file2, "rw").getChannel();
            this.zzbuC = this.zzbuD.tryLock();
            if (this.zzbuC != null) {
                this.zzKk().zzMd().log("Storage concurrent access okay");
                return true;
            }
            this.zzKk().zzLX().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzKk().zzLX().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzKk().zzLX().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    boolean zzy(int n, int n2) {
        this.zzmR();
        if (n > n2) {
            this.zzKk().zzLX().zze("Panic: can't downgrade version. Previous, current version", n, n2);
            return false;
        }
        if (n < n2) {
            if (this.zza(n2, this.zzMA())) {
                this.zzKk().zzMd().zze("Storage version upgraded. Previous, current version", n, n2);
            } else {
                this.zzKk().zzLX().zze("Storage version upgrade failed. Previous, current version", n, n2);
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    int zza(FileChannel fileChannel) {
        this.zzmR();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzKk().zzLX().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzKk().zzLZ().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzKk().zzLX().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    boolean zza(int n, FileChannel fileChannel) {
        this.zzmR();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzKk().zzLX().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzKk().zzLX().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzKk().zzLX().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public boolean isEnabled() {
        this.zzmR();
        this.zzob();
        if (this.zzKm().zzLg()) {
            return false;
        }
        Boolean bl = this.zzKm().zzLh();
        boolean bl2 = bl != null ? bl : !this.zzKm().zzwR();
        return this.zzKl().zzaL(bl2);
    }

    void zzd(zzatd zzatd2) {
        this.zzmR();
        this.zzob();
        zzac.zzdr((String)zzatd2.packageName);
        this.zzf(zzatd2);
    }

    long zzMD() {
        long l = this.zznR().currentTimeMillis() + this.zzKl().zzMh();
        return l / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    zzatd zzfO(String string) {
        Object object;
        zzatc zzatc2 = this.zzKf().zzfu(string);
        if (zzatc2 == null || TextUtils.isEmpty((CharSequence)zzatc2.zzmZ())) {
            this.zzKk().zzMc().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            object = zzadg.zzbi((Context)this.getContext()).getPackageInfo((String)string, (int)0).versionName;
            if (zzatc2.zzmZ() != null && !zzatc2.zzmZ().equals(object)) {
                this.zzKk().zzLZ().zzj("App version does not match; dropping. appId", zzatx.zzfE(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        object = new zzatd(string, zzatc2.getGmpAppId(), zzatc2.zzmZ(), zzatc2.zzKs(), zzatc2.zzKt(), zzatc2.zzKu(), zzatc2.zzKv(), null, zzatc2.zzKw(), false, zzatc2.zzKp(), zzatc2.zzuW());
        return object;
    }

    @WorkerThread
    void zzb(zzatq zzatq2, String string) {
        Object object;
        zzatc zzatc2;
        block4: {
            zzatc2 = this.zzKf().zzfu(string);
            if (zzatc2 == null || TextUtils.isEmpty((CharSequence)zzatc2.zzmZ())) {
                this.zzKk().zzMc().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzadg.zzbi((Context)this.getContext()).getPackageInfo((String)string, (int)0).versionName;
                if (zzatc2.zzmZ() != null && !zzatc2.zzmZ().equals(object)) {
                    this.zzKk().zzLZ().zzj("App version does not match; dropping event. appId", zzatx.zzfE(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzatq2.name)) break block4;
                this.zzKk().zzLZ().zzj("Could not find package. appId", zzatx.zzfE(string));
            }
        }
        object = new zzatd(string, zzatc2.getGmpAppId(), zzatc2.zzmZ(), zzatc2.zzKs(), zzatc2.zzKt(), zzatc2.zzKu(), zzatc2.zzKv(), null, zzatc2.zzKw(), false, zzatc2.zzKp(), zzatc2.zzuW());
        this.zzb(zzatq2, (zzatd)((Object)object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(zzatq zzatq2, zzatd zzatd2) {
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatd2.packageName);
        this.zzmR();
        this.zzob();
        String string = zzatd2.packageName;
        long l = zzatq2.zzbrL;
        if (!this.zzKg().zzd(zzatq2, zzatd2)) {
            return;
        }
        if (!zzatd2.zzbqU) {
            this.zzf(zzatd2);
            return;
        }
        this.zzKf().beginTransaction();
        try {
            Object object;
            Object object22;
            List<zzatg> list = this.zzKf().zzh(string, l);
            for (Object object22 : list) {
                if (object22 == null) continue;
                this.zzKk().zzMc().zzd("User property timed out", object22.packageName, object22.zzbra.name, object22.zzbra.getValue());
                if (object22.zzbre != null) {
                    this.zzc(new zzatq(object22.zzbre, l), zzatd2);
                }
                this.zzKf().zzU(string, object22.zzbra.name);
            }
            List<zzatg> list2 = this.zzKf().zzi(string, l);
            object22 = new ArrayList(list2.size());
            Object object3 = list2.iterator();
            while (object3.hasNext()) {
                object = (zzatg)((Object)object3.next());
                if (object == null) continue;
                this.zzKk().zzMc().zzd("User property expired", object.packageName, object.zzbra.name, object.zzbra.getValue());
                this.zzKf().zzR(string, object.zzbra.name);
                if (object.zzbri != null) {
                    object22.add(object.zzbri);
                }
                this.zzKf().zzU(string, object.zzbra.name);
            }
            object3 = object22.iterator();
            while (object3.hasNext()) {
                object = (zzatq)((Object)object3.next());
                this.zzc(new zzatq((zzatq)((Object)object), l), zzatd2);
            }
            object3 = this.zzKf().zzc(string, zzatq2.name, l);
            object = new ArrayList(object3.size());
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                com.google.android.gms.common.internal.safeparcel.zza zza2 = (zzatg)((Object)iterator.next());
                if (zza2 == null) continue;
                zzauq zzauq2 = zza2.zzbra;
                zzaus zzaus2 = new zzaus(zza2.packageName, zza2.zzbqZ, zzauq2.name, l, zzauq2.getValue());
                boolean bl = this.zzKf().zza(zzaus2);
                if (bl) {
                    this.zzKk().zzMc().zzd("User property triggered", zza2.packageName, zzaus2.mName, zzaus2.mValue);
                } else {
                    this.zzKk().zzLX().zzd("Too many active user properties, ignoring", zzatx.zzfE(zza2.packageName), zzaus2.mName, zzaus2.mValue);
                }
                if (zza2.zzbrg != null) {
                    object.add(zza2.zzbrg);
                }
                zza2.zzbra = new zzauq(zzaus2);
                zza2.zzbrc = true;
                this.zzKf().zza((zzatg)zza2);
            }
            this.zzc(zzatq2, zzatd2);
            for (com.google.android.gms.common.internal.safeparcel.zza zza2 : object) {
                this.zzc(new zzatq((zzatq)zza2, l), zzatd2);
            }
            this.zzKf().setTransactionSuccessful();
        }
        finally {
            this.zzKf().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzc(zzatq zzatq2, zzatd zzatd2) {
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatd2.packageName);
        long l = System.nanoTime();
        this.zzmR();
        this.zzob();
        String string = zzatd2.packageName;
        if (!this.zzKg().zzd(zzatq2, zzatd2)) {
            return;
        }
        if (!zzatd2.zzbqU) {
            this.zzf(zzatd2);
            return;
        }
        if (this.zzKh().zzaa(string, zzatq2.name)) {
            zzatc zzatc2;
            boolean bl;
            this.zzKk().zzLZ().zze("Dropping blacklisted event. appId", zzatx.zzfE(string), zzatq2.name);
            boolean bl2 = bl = this.zzKg().zzgg(string) || this.zzKg().zzgh(string);
            if (!bl && !"_err".equals(zzatq2.name)) {
                this.zzKg().zza(11, "_ev", zzatq2.name, 0);
            }
            if (bl && (zzatc2 = this.zzKf().zzfu(string)) != null) {
                long l2 = Math.max(zzatc2.zzKz(), zzatc2.zzKy());
                long l3 = this.zznR().currentTimeMillis();
                if (Math.abs(l3 - l2) > this.zzKm().zzLk()) {
                    this.zzKk().zzMc().log("Fetching config for blacklisted app");
                    this.zzb(zzatc2);
                }
            }
            return;
        }
        if (this.zzKk().zzak(2)) {
            this.zzKk().zzMd().zzj("Logging event", (Object)zzatq2);
        }
        this.zzKf().beginTransaction();
        try {
            zzatn zzatn2;
            long l4;
            Bundle bundle = zzatq2.zzbrK.zzLV();
            this.zzf(zzatd2);
            if ("_iap".equals(zzatq2.name) || "ecommerce_purchase".equals(zzatq2.name)) {
                long l5;
                String string2 = bundle.getString("currency");
                if ("ecommerce_purchase".equals(zzatq2.name)) {
                    double d = bundle.getDouble("value") * 1000000.0;
                    if (d == 0.0) {
                        d = (double)bundle.getLong("value") * 1000000.0;
                    }
                    if (!(d <= 9.223372036854776E18) || !(d >= -9.223372036854776E18)) {
                        this.zzKk().zzLZ().zze("Data lost. Currency value is too big. appId", zzatx.zzfE(string), d);
                        this.zzKf().setTransactionSuccessful();
                        return;
                    }
                    l5 = Math.round(d);
                } else {
                    l5 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string3 = String.valueOf("_ltv_");
                    String string4 = String.valueOf(string2);
                    String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                    zzaus zzaus2 = this.zzKf().zzS(string, string5);
                    if (zzaus2 == null || !(zzaus2.mValue instanceof Long)) {
                        this.zzKf().zzz(string, this.zzKm().zzfn(string) - 1);
                        zzaus2 = new zzaus(string, zzatq2.zzbqZ, string5, this.zznR().currentTimeMillis(), l5);
                    } else {
                        l4 = (Long)zzaus2.mValue;
                        zzaus2 = new zzaus(string, zzatq2.zzbqZ, string5, this.zznR().currentTimeMillis(), l4 + l5);
                    }
                    if (!this.zzKf().zza(zzaus2)) {
                        this.zzKk().zzLX().zzd("Too many unique user properties are set. Ignoring user property. appId", zzatx.zzfE(string), zzaus2.mName, zzaus2.mValue);
                        this.zzKg().zza(9, null, null, 0);
                    }
                }
            }
            boolean bl = zzaut.zzfT(zzatq2.name);
            boolean bl3 = "_err".equals(zzatq2.name);
            zzatj.zza zza2 = this.zzKf().zza(this.zzMD(), string, true, bl, false, bl3, false);
            long l6 = zza2.zzbrs - this.zzKm().zzKT();
            if (l6 > 0L) {
                if (l6 % 1000L == 1L) {
                    this.zzKk().zzLX().zze("Data loss. Too many events logged. appId, count", zzatx.zzfE(string), zza2.zzbrs);
                }
                this.zzKg().zza(16, "_ev", zzatq2.name, 0);
                this.zzKf().setTransactionSuccessful();
                return;
            }
            if (bl && (l6 = zza2.zzbrr - this.zzKm().zzKU()) > 0L) {
                if (l6 % 1000L == 1L) {
                    this.zzKk().zzLX().zze("Data loss. Too many public events logged. appId, count", zzatx.zzfE(string), zza2.zzbrr);
                }
                this.zzKg().zza(16, "_ev", zzatq2.name, 0);
                this.zzKf().setTransactionSuccessful();
                return;
            }
            if (bl3 && (l6 = zza2.zzbru - (long)this.zzKm().zzfj(zzatd2.packageName)) > 0L) {
                if (l6 == 1L) {
                    this.zzKk().zzLX().zze("Too many error events logged. appId, count", zzatx.zzfE(string), zza2.zzbru);
                }
                this.zzKf().setTransactionSuccessful();
                return;
            }
            this.zzKg().zza(bundle, "_o", zzatq2.zzbqZ);
            if (this.zzKg().zzge(string)) {
                this.zzKg().zza(bundle, "_dbg", 1L);
                this.zzKg().zza(bundle, "_r", 1L);
            }
            if ((l4 = this.zzKf().zzfv(string)) > 0L) {
                this.zzKk().zzLZ().zze("Data lost. Too many events stored on disk, deleted. appId", zzatx.zzfE(string), l4);
            }
            zzatm zzatm2 = new zzatm(this, zzatq2.zzbqZ, string, zzatq2.name, zzatq2.zzbrL, 0L, bundle);
            zzatn zzatn3 = this.zzKf().zzQ(string, zzatm2.mName);
            if (zzatn3 == null) {
                long l7 = this.zzKf().zzfC(string);
                this.zzKm().zzKS();
                if (l7 >= 500L) {
                    this.zzKk().zzLX().zzd("Too many event names used, ignoring event. appId, name, supported count", zzatx.zzfE(string), zzatm2.mName, this.zzKm().zzKS());
                    this.zzKg().zza(8, null, null, 0);
                    return;
                }
                zzatn2 = new zzatn(string, zzatm2.mName, 0L, 0L, zzatm2.zzaxb);
            } else {
                zzatm2 = zzatm2.zza(this, zzatn3.zzbrG);
                zzatn2 = zzatn3.zzap(zzatm2.zzaxb);
            }
            this.zzKf().zza(zzatn2);
            this.zza(zzatm2, zzatd2);
            this.zzKf().setTransactionSuccessful();
            if (this.zzKk().zzak(2)) {
                this.zzKk().zzMd().zzj("Event recorded", zzatm2);
            }
        }
        finally {
            this.zzKf().endTransaction();
        }
        this.zzMH();
        this.zzKk().zzMd().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    @WorkerThread
    void zzd(zzatg zzatg2) {
        zzatd zzatd2 = this.zzfO(zzatg2.packageName);
        if (zzatd2 != null) {
            this.zzb(zzatg2, zzatd2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(zzatg zzatg2, zzatd zzatd2) {
        zzac.zzw((Object)((Object)zzatg2));
        zzac.zzdr((String)zzatg2.packageName);
        zzac.zzw((Object)zzatg2.zzbqZ);
        zzac.zzw((Object)((Object)zzatg2.zzbra));
        zzac.zzdr((String)zzatg2.zzbra.name);
        this.zzmR();
        this.zzob();
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqP)) {
            return;
        }
        if (!zzatd2.zzbqU) {
            this.zzf(zzatd2);
            return;
        }
        zzatg zzatg3 = new zzatg(zzatg2);
        this.zzKf().beginTransaction();
        try {
            boolean bl;
            zzauq zzauq2;
            boolean bl2 = false;
            zzatg zzatg4 = this.zzKf().zzT(zzatg3.packageName, zzatg3.zzbra.name);
            if (zzatg4 != null && zzatg4.zzbrc) {
                zzatg3.zzbqZ = zzatg4.zzbqZ;
                zzatg3.zzbrb = zzatg4.zzbrb;
                zzatg3.zzbrd = zzatg4.zzbrd;
                zzatg3.zzbrg = zzatg4.zzbrg;
            } else if (TextUtils.isEmpty((CharSequence)zzatg3.zzbrd)) {
                zzauq2 = zzatg3.zzbra;
                zzatg3.zzbra = new zzauq(zzauq2.name, zzatg3.zzbrb, zzauq2.getValue(), zzauq2.zzbqZ);
                zzatg3.zzbrc = true;
                bl2 = true;
            }
            if (zzatg3.zzbrc) {
                zzauq2 = zzatg3.zzbra;
                zzaus zzaus2 = new zzaus(zzatg3.packageName, zzatg3.zzbqZ, zzauq2.name, zzauq2.zzbwg, zzauq2.getValue());
                boolean bl3 = this.zzKf().zza(zzaus2);
                if (bl3) {
                    this.zzKk().zzMc().zzd("User property updated immediately", zzatg3.packageName, zzaus2.mName, zzaus2.mValue);
                } else {
                    this.zzKk().zzLX().zzd("(2)Too many active user properties, ignoring", zzatx.zzfE(zzatg3.packageName), zzaus2.mName, zzaus2.mValue);
                }
                if (bl2 && zzatg3.zzbrg != null) {
                    zzatq zzatq2 = new zzatq(zzatg3.zzbrg, zzatg3.zzbrb);
                    this.zzc(zzatq2, zzatd2);
                }
            }
            if (bl = this.zzKf().zza(zzatg3)) {
                this.zzKk().zzMc().zzd("Conditional property added", zzatg3.packageName, zzatg3.zzbra.name, zzatg3.zzbra.getValue());
            } else {
                this.zzKk().zzLX().zzd("Too many conditional properties, ignoring", zzatx.zzfE(zzatg3.packageName), zzatg3.zzbra.name, zzatg3.zzbra.getValue());
            }
            this.zzKf().setTransactionSuccessful();
        }
        finally {
            this.zzKf().endTransaction();
        }
    }

    @WorkerThread
    void zze(zzatg zzatg2) {
        zzatd zzatd2 = this.zzfO(zzatg2.packageName);
        if (zzatd2 != null) {
            this.zzc(zzatg2, zzatd2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzc(zzatg zzatg2, zzatd zzatd2) {
        zzac.zzw((Object)((Object)zzatg2));
        zzac.zzdr((String)zzatg2.packageName);
        zzac.zzw((Object)((Object)zzatg2.zzbra));
        zzac.zzdr((String)zzatg2.zzbra.name);
        this.zzmR();
        this.zzob();
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqP)) {
            return;
        }
        if (!zzatd2.zzbqU) {
            this.zzf(zzatd2);
            return;
        }
        this.zzKf().beginTransaction();
        try {
            this.zzf(zzatd2);
            zzatg zzatg3 = this.zzKf().zzT(zzatg2.packageName, zzatg2.zzbra.name);
            if (zzatg3 != null) {
                this.zzKk().zzMc().zze("Removing conditional user property", zzatg2.packageName, zzatg2.zzbra.name);
                this.zzKf().zzU(zzatg2.packageName, zzatg2.zzbra.name);
                if (zzatg3.zzbrc) {
                    this.zzKf().zzR(zzatg2.packageName, zzatg2.zzbra.name);
                }
                if (zzatg2.zzbri != null) {
                    Bundle bundle = null;
                    if (zzatg2.zzbri.zzbrK != null) {
                        bundle = zzatg2.zzbri.zzbrK.zzLV();
                    }
                    zzatq zzatq2 = this.zzKg().zza(zzatg2.zzbri.name, bundle, zzatg3.zzbqZ, zzatg2.zzbri.zzbrL, true, false);
                    this.zzc(zzatq2, zzatd2);
                }
            } else {
                this.zzKk().zzLZ().zze("Conditional user property doesn't exist", zzatx.zzfE(zzatg2.packageName), zzatg2.zzbra.name);
            }
            this.zzKf().setTransactionSuccessful();
        }
        finally {
            this.zzKf().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zza(@NonNull zzatq zzatq2, @Size(min=1L) String string) {
        Object object;
        zzbxm zzbxm2;
        Object object2;
        this.zzob();
        this.zzmR();
        this.zzJU();
        zzac.zzw((Object)((Object)zzatq2));
        zzac.zzdr((String)string);
        zzauw.zzd zzd2 = new zzauw.zzd();
        this.zzKf().beginTransaction();
        try {
            zzatn zzatn2;
            long l;
            Object object3;
            zzatc zzatc2 = this.zzKf().zzfu(string);
            if (zzatc2 == null) {
                this.zzKk().zzMc().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzatc2.zzKw()) {
                this.zzKk().zzMc().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object2 = new zzauw.zze();
            zzd2.zzbxh = new zzauw.zze[]{object2};
            object2.zzbxj = 1;
            object2.zzbxr = "android";
            object2.zzaS = zzatc2.zzke();
            object2.zzbqQ = zzatc2.zzKt();
            object2.zzbhM = zzatc2.zzmZ();
            object2.zzbxE = (int)zzatc2.zzKs();
            object2.zzbxv = zzatc2.zzKu();
            object2.zzbqP = zzatc2.getGmpAppId();
            object2.zzbxA = zzatc2.zzKv();
            zzbxm2 = this.zzKl().zzfG(zzatc2.zzke());
            if (!TextUtils.isEmpty((CharSequence)((CharSequence)zzbxm2.first))) {
                object2.zzbxx = (String)zzbxm2.first;
                object2.zzbxy = (Boolean)zzbxm2.second;
            }
            object2.zzbxs = this.zzKb().zzkN();
            object2.zzbb = this.zzKb().zzLR();
            object2.zzbxu = (int)this.zzKb().zzLS();
            object2.zzbxt = this.zzKb().zzLT();
            object2.zzbxz = zzatc2.getAppInstanceId();
            object2.zzbqX = zzatc2.zzKp();
            object = this.zzKf().zzft(zzatc2.zzke());
            object2.zzbxl = new zzauw.zzg[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                object3 = new zzauw.zzg();
                object2.zzbxl[i] = object3;
                ((zzauw.zzg)((Object)object3)).name = object.get((int)i).mName;
                ((zzauw.zzg)((Object)object3)).zzbxN = object.get((int)i).zzbwk;
                this.zzKg().zza((zzauw.zzg)((Object)object3), object.get((int)i).mValue);
            }
            Bundle bundle = zzatq2.zzbrK.zzLV();
            if ("_iap".equals(zzatq2.name)) {
                bundle.putLong("_c", 1L);
                this.zzKk().zzMc().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzatq2.zzbqZ);
            if (this.zzKg().zzge(object2.zzaS)) {
                this.zzKg().zza(bundle, "_dbg", 1L);
                this.zzKg().zza(bundle, "_r", 1L);
            }
            if ((object3 = this.zzKf().zzQ(string, zzatq2.name)) == null) {
                l = 0L;
                zzatn2 = new zzatn(string, zzatq2.name, 1L, 0L, zzatq2.zzbrL);
                this.zzKf().zza(zzatn2);
            } else {
                l = ((zzatn)object3).zzbrG;
                zzatn2 = ((zzatn)object3).zzap(zzatq2.zzbrL);
                zzatn2 = zzatn2.zzLU();
                this.zzKf().zza(zzatn2);
            }
            zzatm zzatm2 = new zzatm(this, zzatq2.zzbqZ, string, zzatq2.name, zzatq2.zzbrL, l, bundle);
            zzauw.zzb zzb2 = new zzauw.zzb();
            object2.zzbxk = new zzauw.zzb[]{zzb2};
            zzb2.zzbxd = zzatm2.zzaxb;
            zzb2.name = zzatm2.mName;
            zzb2.zzbxe = zzatm2.zzbrC;
            zzb2.zzbxc = new zzauw.zzc[zzatm2.zzbrD.size()];
            int n = 0;
            for (String string2 : zzatm2.zzbrD) {
                zzauw.zzc zzc2 = new zzauw.zzc();
                zzb2.zzbxc[n++] = zzc2;
                zzc2.name = string2;
                Object object4 = zzatm2.zzbrD.get(string2);
                this.zzKg().zza(zzc2, object4);
            }
            object2.zzbxD = this.zza(zzatc2.zzke(), object2.zzbxl, object2.zzbxk);
            object2.zzbxn = zzb2.zzbxd;
            object2.zzbxo = zzb2.zzbxd;
            long l2 = zzatc2.zzKr();
            object2.zzbxq = l2 != 0L ? Long.valueOf(l2) : null;
            long l3 = zzatc2.zzKq();
            if (l3 == 0L) {
                l3 = l2;
            }
            object2.zzbxp = l3 != 0L ? Long.valueOf(l3) : null;
            zzatc2.zzKA();
            object2.zzbxB = (int)zzatc2.zzKx();
            object2.zzbxw = this.zzKm().zzKu();
            object2.zzbxm = this.zznR().currentTimeMillis();
            object2.zzbxC = Boolean.TRUE;
            zzatc2.zzY(object2.zzbxn);
            zzatc2.zzZ(object2.zzbxo);
            this.zzKf().zza(zzatc2);
            this.zzKf().setTransactionSuccessful();
        }
        finally {
            this.zzKf().endTransaction();
        }
        try {
            int n = zzd2.zzaeS();
            object2 = new byte[n];
            zzbxm2 = zzbxm.zzag((byte[])object2);
            zzd2.zza(zzbxm2);
            zzbxm2.zzaeF();
            object = this.zzKg().zzk((byte[])object2);
            return object;
        }
        catch (IOException iOException) {
            this.zzKk().zzLX().zze("Data loss. Failed to bundle and serialize. appId", zzatx.zzfE(string), iOException);
            return null;
        }
    }

    void zza(zzatm zzatm2, zzatd zzatd2) {
        long l;
        Object object;
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)zzatm2);
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatm2.mAppId);
        zzac.zzax((boolean)zzatm2.mAppId.equals(zzatd2.packageName));
        zzauw.zze zze2 = new zzauw.zze();
        zze2.zzbxj = 1;
        zze2.zzbxr = "android";
        zze2.zzaS = zzatd2.packageName;
        zze2.zzbqQ = zzatd2.zzbqQ;
        zze2.zzbhM = zzatd2.zzbhM;
        zze2.zzbxE = (int)zzatd2.zzbqW;
        zze2.zzbxv = zzatd2.zzbqR;
        zze2.zzbqP = zzatd2.zzbqP;
        zze2.zzbxA = zzatd2.zzbqS == 0L ? null : Long.valueOf(zzatd2.zzbqS);
        Pair<String, Boolean> pair = this.zzKl().zzfG(zzatd2.packageName);
        if (!TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            zze2.zzbxx = (String)pair.first;
            zze2.zzbxy = (Boolean)pair.second;
        } else if (!this.zzKb().zzbL(this.mContext)) {
            object = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            if (object == null) {
                this.zzKk().zzLZ().zzj("null secure ID. appId", zzatx.zzfE(zze2.zzaS));
                object = "null";
            } else if (((String)object).isEmpty()) {
                this.zzKk().zzLZ().zzj("empty secure ID. appId", zzatx.zzfE(zze2.zzaS));
            }
            zze2.zzbxH = object;
        }
        zze2.zzbxs = this.zzKb().zzkN();
        zze2.zzbb = this.zzKb().zzLR();
        zze2.zzbxu = (int)this.zzKb().zzLS();
        zze2.zzbxt = this.zzKb().zzLT();
        zze2.zzbxw = null;
        zze2.zzbxm = null;
        zze2.zzbxn = null;
        zze2.zzbxo = null;
        zze2.zzbxJ = zzatd2.zzbqY;
        object = this.zzKf().zzfu(zzatd2.packageName);
        if (object == null) {
            object = new zzatc(this, zzatd2.packageName);
            ((zzatc)object).zzfd(this.zzKl().zzMg());
            ((zzatc)object).zzfg(zzatd2.zzbqX);
            ((zzatc)object).zzfe(zzatd2.zzbqP);
            ((zzatc)object).zzff(this.zzKl().zzfH(zzatd2.packageName));
            ((zzatc)object).zzad(0L);
            ((zzatc)object).zzY(0L);
            ((zzatc)object).zzZ(0L);
            ((zzatc)object).setAppVersion(zzatd2.zzbhM);
            ((zzatc)object).zzaa(zzatd2.zzbqW);
            ((zzatc)object).zzfh(zzatd2.zzbqQ);
            ((zzatc)object).zzab(zzatd2.zzbqR);
            ((zzatc)object).zzac(zzatd2.zzbqS);
            ((zzatc)object).setMeasurementEnabled(zzatd2.zzbqU);
            ((zzatc)object).zzam(zzatd2.zzbqY);
            this.zzKf().zza((zzatc)object);
        }
        zze2.zzbxz = ((zzatc)object).getAppInstanceId();
        zze2.zzbqX = ((zzatc)object).zzKp();
        List<zzaus> list = this.zzKf().zzft(zzatd2.packageName);
        zze2.zzbxl = new zzauw.zzg[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            zzauw.zzg zzg2;
            zze2.zzbxl[i] = zzg2 = new zzauw.zzg();
            zzg2.name = list.get((int)i).mName;
            zzg2.zzbxN = list.get((int)i).zzbwk;
            this.zzKg().zza(zzg2, list.get((int)i).mValue);
        }
        try {
            l = this.zzKf().zza(zze2);
        }
        catch (IOException iOException) {
            this.zzKk().zzLX().zze("Data loss. Failed to insert raw event metadata. appId", zzatx.zzfE(zze2.zzaS), iOException);
            return;
        }
        if (this.zzKf().zza(zzatm2, l, this.zza(zzatm2))) {
            this.zzbuI = 0L;
        }
    }

    public String zzfP(final String string) {
        Future<String> future = this.zzKj().zzd(new Callable<String>(){

            public String zzbY() throws Exception {
                zzatc zzatc2 = zzaue.this.zzKf().zzfu(string);
                if (zzatc2 == null) {
                    return null;
                }
                return zzatc2.getAppInstanceId();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbY();
            }
        });
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzKk().zzLX().zze("Failed to get app instance id. appId", zzatx.zzfE(string), exception);
            return null;
        }
    }

    private boolean zza(zzatm zzatm2) {
        Object object2;
        if (zzatm2.zzbrD == null) {
            return false;
        }
        for (Object object2 : zzatm2.zzbrD) {
            if (!"_r".equals(object2)) continue;
            return true;
        }
        boolean bl = this.zzKh().zzab(zzatm2.mAppId, zzatm2.mName);
        object2 = this.zzKf().zza(this.zzMD(), zzatm2.mAppId, false, false, false, false, false);
        return bl && ((zzatj.zza)object2).zzbrv < (long)this.zzKm().zzfl(zzatm2.mAppId);
    }

    void zzJV() {
        this.zzKm().zzLf();
    }

    void zzJU() {
        this.zzKm().zzLf();
        throw new IllegalStateException("Unexpected call on client side");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(zzauq zzauq2, zzatd zzatd2) {
        this.zzmR();
        this.zzob();
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqP)) {
            return;
        }
        if (!zzatd2.zzbqU) {
            this.zzf(zzatd2);
            return;
        }
        int n = this.zzKg().zzfX(zzauq2.name);
        if (n != 0) {
            String string = this.zzKg().zza(zzauq2.name, this.zzKm().zzKM(), true);
            int n2 = zzauq2.name != null ? zzauq2.name.length() : 0;
            this.zzKg().zza(n, "_ev", string, n2);
            return;
        }
        n = this.zzKg().zzm(zzauq2.name, zzauq2.getValue());
        if (n != 0) {
            String string = this.zzKg().zza(zzauq2.name, this.zzKm().zzKM(), true);
            Object object = zzauq2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                String string2 = String.valueOf(object);
                n3 = string2.length();
            }
            this.zzKg().zza(n, "_ev", string, n3);
            return;
        }
        Object object = this.zzKg().zzn(zzauq2.name, zzauq2.getValue());
        if (object == null) {
            return;
        }
        zzaus zzaus2 = new zzaus(zzatd2.packageName, zzauq2.zzbqZ, zzauq2.name, zzauq2.zzbwg, object);
        this.zzKk().zzMc().zze("Setting user property", zzaus2.mName, object);
        this.zzKf().beginTransaction();
        try {
            this.zzf(zzatd2);
            boolean bl = this.zzKf().zza(zzaus2);
            this.zzKf().setTransactionSuccessful();
            if (bl) {
                this.zzKk().zzMc().zze("User property set", zzaus2.mName, zzaus2.mValue);
            } else {
                this.zzKk().zzLX().zze("Too many unique user properties are set. Ignoring user property", zzaus2.mName, zzaus2.mValue);
                this.zzKg().zza(9, null, null, 0);
            }
        }
        finally {
            this.zzKf().endTransaction();
        }
    }

    @WorkerThread
    void zzc(zzauq zzauq2, zzatd zzatd2) {
        this.zzmR();
        this.zzob();
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqP)) {
            return;
        }
        if (!zzatd2.zzbqU) {
            this.zzf(zzatd2);
            return;
        }
        this.zzKk().zzMc().zzj("Removing user property", zzauq2.name);
        this.zzKf().beginTransaction();
        try {
            this.zzf(zzatd2);
            this.zzKf().zzR(zzatd2.packageName, zzauq2.name);
            this.zzKf().setTransactionSuccessful();
            this.zzKk().zzMc().zzj("User property removed", zzauq2.name);
        }
        finally {
            this.zzKf().endTransaction();
        }
    }

    @WorkerThread
    protected boolean zzME() {
        this.zzmR();
        return this.zzbuE != null;
    }

    protected void zzK(List<Long> list) {
        zzac.zzax((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzbuE != null) {
            this.zzKk().zzLX().log("Set uploading progress before finishing the previous upload");
        } else {
            this.zzbuE = new ArrayList<Long>(list);
        }
    }

    @WorkerThread
    public void zzMF() {
        String string;
        this.zzmR();
        this.zzob();
        this.zzKm().zzLf();
        Boolean bl = this.zzKl().zzMl();
        if (bl == null) {
            this.zzKk().zzLZ().log("Upload data called on the client side before use of service was decided");
            return;
        }
        if (bl.booleanValue()) {
            this.zzKk().zzLX().log("Upload called in the client side when service should be used");
            return;
        }
        if (this.zzbuI > 0L) {
            this.zzMH();
            return;
        }
        if (this.zzME()) {
            this.zzKk().zzLZ().log("Uploading requested multiple times");
            return;
        }
        if (!this.zzMx().zzqa()) {
            this.zzKk().zzLZ().log("Network not connected, ignoring upload request");
            this.zzMH();
            return;
        }
        long l = this.zznR().currentTimeMillis();
        this.zzaq(l - this.zzKm().zzLq());
        long l2 = this.zzKl().zzbtd.get();
        if (l2 != 0L) {
            this.zzKk().zzMc().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.zzKf().zzLC()))) {
            if (this.zzbuH == -1L) {
                this.zzbuH = this.zzKf().zzLK();
            }
            int n = this.zzKm().zzfq(string);
            int n2 = this.zzKm().zzfr(string);
            List<Pair<zzauw.zze, Long>> list = this.zzKf().zzn(string, n, n2);
            if (!list.isEmpty()) {
                String string2 = null;
                for (Pair<zzauw.zze, Long> object2 : list) {
                    zzauw.zze zze2 = (zzauw.zze)((Object)object2.first);
                    if (TextUtils.isEmpty((CharSequence)zze2.zzbxx)) continue;
                    string2 = zze2.zzbxx;
                    break;
                }
                if (string2 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzauw.zze zze3 = (zzauw.zze)((Object)list.get((int)i).first);
                        if (TextUtils.isEmpty((CharSequence)zze3.zzbxx) || zze3.zzbxx.equals(string2)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                Object object3 = new zzauw.zzd();
                ((zzauw.zzd)((Object)object3)).zzbxh = new zzauw.zze[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                for (int i = 0; i < ((zzauw.zzd)((Object)object3)).zzbxh.length; ++i) {
                    ((zzauw.zzd)((Object)object3)).zzbxh[i] = (zzauw.zze)((Object)list.get((int)i).first);
                    arrayList.add((Long)list.get((int)i).second);
                    ((zzauw.zzd)((Object)object3)).zzbxh[i].zzbxw = this.zzKm().zzKu();
                    ((zzauw.zzd)((Object)object3)).zzbxh[i].zzbxm = l;
                    ((zzauw.zzd)((Object)object3)).zzbxh[i].zzbxC = this.zzKm().zzLf();
                }
                String string3 = null;
                if (this.zzKk().zzak(2)) {
                    string3 = zzaut.zzb(object3);
                }
                byte[] byArray = this.zzKg().zza((zzauw.zzd)((Object)object3));
                String string4 = this.zzKm().zzLp();
                try {
                    URL uRL = new URL(string4);
                    this.zzK(arrayList);
                    this.zzKl().zzbte.set(l);
                    String string5 = "?";
                    if (((zzauw.zzd)((Object)object3)).zzbxh.length > 0) {
                        string5 = ((zzauw.zzd)((Object)object3)).zzbxh[0].zzaS;
                    }
                    this.zzKk().zzMd().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                    this.zzMx().zza(string, uRL, byArray, null, new zzaty.zza(){

                        @Override
                        public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                            zzaue.this.zza(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzKk().zzLX().zze("Failed to parse upload URL. Not uploading. appId", zzatx.zzfE(string), string4);
                }
            }
        } else {
            zzatc zzatc2;
            this.zzbuH = -1L;
            String string6 = this.zzKf().zzao(l - this.zzKm().zzLq());
            if (!TextUtils.isEmpty((CharSequence)string6) && (zzatc2 = this.zzKf().zzfu(string6)) != null) {
                this.zzb(zzatc2);
            }
        }
    }

    void zzb(zzatc zzatc2) {
        if (TextUtils.isEmpty((CharSequence)zzatc2.getGmpAppId())) {
            this.zzb(zzatc2.zzke(), 204, null, null, null);
            return;
        }
        String string = this.zzKm().zzP(zzatc2.getGmpAppId(), zzatc2.getAppInstanceId());
        try {
            URL uRL = new URL(string);
            this.zzKk().zzMd().zzj("Fetching remote configuration", zzatc2.zzke());
            zzauv.zzb zzb2 = this.zzKh().zzfL(zzatc2.zzke());
            ArrayMap arrayMap = null;
            String string2 = this.zzKh().zzfM(zzatc2.zzke());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            this.zzMx().zza(zzatc2.zzke(), uRL, (Map<String, String>)arrayMap, new zzaty.zza(){

                @Override
                public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                    zzaue.this.zzb(string, n, throwable, byArray, map);
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            this.zzKk().zzLX().zze("Failed to parse config URL. Not fetching. appId", zzatx.zzfE(zzatc2.zzke()), string);
        }
    }

    boolean zzaq(long l) {
        return this.zzl(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private boolean zzl(String string, long l) {
        this.zzKf().beginTransaction();
        try {
            zza zza2 = new zza();
            this.zzKf().zza(string, l, this.zzbuH, zza2);
            if (!zza2.isEmpty()) {
                int n;
                boolean bl = false;
                zzauw.zze zze2 = zza2.zzbuK;
                zze2.zzbxk = new zzauw.zzb[zza2.zzth.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzth.size(); ++n) {
                    boolean bl2;
                    boolean bl3 = bl;
                    if (this.zzKh().zzaa(zza2.zzbuK.zzaS, zza2.zzth.get((int)n).name)) {
                        this.zzKk().zzLZ().zze("Dropping blacklisted raw event. appId", zzatx.zzfE(zza2.zzbuK.zzaS), zza2.zzth.get((int)n).name);
                        boolean bl4 = bl2 = this.zzKg().zzgg(zza2.zzbuK.zzaS) || this.zzKg().zzgh(zza2.zzbuK.zzaS);
                        if (bl2 || "_err".equals(zza2.zzth.get((int)n).name)) continue;
                        this.zzKg().zza(11, "_ev", zza2.zzth.get((int)n).name, 0);
                        continue;
                    }
                    bl2 = this.zzKh().zzab(zza2.zzbuK.zzaS, zza2.zzth.get((int)n).name);
                    if (bl2 || this.zzKg().zzgi(zza2.zzth.get((int)n).name)) {
                        int n3;
                        Object object;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        if (zza2.zzth.get((int)n).zzbxc == null) {
                            zza2.zzth.get((int)n).zzbxc = new zzauw.zzc[0];
                        }
                        for (zzauw.zzc[] zzcArray : zza2.zzth.get((int)n).zzbxc) {
                            if ("_c".equals(zzcArray.name)) {
                                zzcArray.zzbxg = 1L;
                                bl5 = true;
                                continue;
                            }
                            if (!"_r".equals(zzcArray.name)) continue;
                            zzcArray.zzbxg = 1L;
                            bl6 = true;
                        }
                        if (!bl5 && bl2) {
                            this.zzKk().zzMd().zzj("Marking event as conversion", zza2.zzth.get((int)n).name);
                            object = Arrays.copyOf(zza2.zzth.get((int)n).zzbxc, zza2.zzth.get((int)n).zzbxc.length + 1);
                            zzauw.zzc zzc2 = new zzauw.zzc();
                            zzc2.name = "_c";
                            zzc2.zzbxg = 1L;
                            object[((zzauw.zzc[])object).length - 1] = zzc2;
                            zza2.zzth.get((int)n).zzbxc = object;
                        }
                        if (!bl6) {
                            this.zzKk().zzMd().zzj("Marking event as real-time", zza2.zzth.get((int)n).name);
                            object = Arrays.copyOf(zza2.zzth.get((int)n).zzbxc, zza2.zzth.get((int)n).zzbxc.length + 1);
                            zzauw.zzc zzc3 = new zzauw.zzc();
                            zzc3.name = "_r";
                            zzc3.zzbxg = 1L;
                            object[((zzauw.zzc[])object).length - 1] = zzc3;
                            zza2.zzth.get((int)n).zzbxc = object;
                        }
                        bl = true;
                        object = this.zzKf().zza(this.zzMD(), zza2.zzbuK.zzaS, false, false, false, false, true);
                        if (object.zzbrv > (long)this.zzKm().zzfl(zza2.zzbuK.zzaS)) {
                            zzauw.zzb zzb2 = zza2.zzth.get(n);
                            for (int i = 0; i < zzb2.zzbxc.length; ++i) {
                                zzauw.zzc[] zzcArray;
                                if (!"_r".equals(zzb2.zzbxc[i].name)) continue;
                                zzcArray = new zzauw.zzc[zzb2.zzbxc.length - 1];
                                if (i > 0) {
                                    System.arraycopy(zzb2.zzbxc, 0, zzcArray, 0, i);
                                }
                                if (i < zzcArray.length) {
                                    System.arraycopy(zzb2.zzbxc, i + 1, zzcArray, i, zzcArray.length - i);
                                }
                                zzb2.zzbxc = zzcArray;
                                break;
                            }
                            bl = bl3;
                        }
                        if ((n3 = (int)(zzaut.zzfT(zza2.zzth.get((int)n).name) ? 1 : 0)) != 0 && bl2) {
                            object = this.zzKf().zza(this.zzMD(), zza2.zzbuK.zzaS, false, false, true, false, false);
                            if (object.zzbrt > (long)this.zzKm().zzfk(zza2.zzbuK.zzaS)) {
                                this.zzKk().zzLZ().zzj("Too many conversions. Not logging as conversion. appId", zzatx.zzfE(zza2.zzbuK.zzaS));
                                zzauw.zzb zzb3 = zza2.zzth.get(n);
                                boolean bl7 = false;
                                zzauw.zzc zzc4 = null;
                                for (zzauw.zzc zzc5 : zzb3.zzbxc) {
                                    if ("_c".equals(zzc5.name)) {
                                        zzc4 = zzc5;
                                        continue;
                                    }
                                    if (!"_err".equals(zzc5.name)) continue;
                                    bl7 = true;
                                }
                                if (bl7 && zzc4 != null) {
                                    zzauw.zzc[] zzcArray = new zzauw.zzc[zzb3.zzbxc.length - 1];
                                    int n4 = 0;
                                    for (zzauw.zzc zzc6 : zzb3.zzbxc) {
                                        if (zzc6 == zzc4) continue;
                                        zzcArray[n4++] = zzc6;
                                    }
                                    zzb3.zzbxc = zzcArray;
                                } else if (zzc4 != null) {
                                    zzc4.name = "_err";
                                    zzc4.zzbxg = 10L;
                                } else {
                                    this.zzKk().zzLX().zzj("Did not find conversion parameter. appId", zzatx.zzfE(zza2.zzbuK.zzaS));
                                }
                            }
                        }
                    }
                    zze2.zzbxk[n2++] = zza2.zzth.get(n);
                }
                if (n2 < zza2.zzth.size()) {
                    zze2.zzbxk = Arrays.copyOf(zze2.zzbxk, n2);
                }
                zze2.zzbxD = this.zza(zza2.zzbuK.zzaS, zza2.zzbuK.zzbxl, zze2.zzbxk);
                zze2.zzbxn = Long.MAX_VALUE;
                zze2.zzbxo = Long.MIN_VALUE;
                for (n = 0; n < zze2.zzbxk.length; ++n) {
                    zzauw.zzb zzb4 = zze2.zzbxk[n];
                    if (zzb4.zzbxd < zze2.zzbxn) {
                        zze2.zzbxn = zzb4.zzbxd;
                    }
                    if (zzb4.zzbxd <= zze2.zzbxo) continue;
                    zze2.zzbxo = zzb4.zzbxd;
                }
                String string2 = zza2.zzbuK.zzaS;
                zzatc zzatc2 = this.zzKf().zzfu(string2);
                if (zzatc2 == null) {
                    this.zzKk().zzLX().zzj("Bundling raw events w/o app info. appId", zzatx.zzfE(zza2.zzbuK.zzaS));
                } else if (zze2.zzbxk.length > 0) {
                    long l2 = zzatc2.zzKr();
                    zze2.zzbxq = l2 != 0L ? Long.valueOf(l2) : null;
                    long l3 = zzatc2.zzKq();
                    if (l3 == 0L) {
                        l3 = l2;
                    }
                    zze2.zzbxp = l3 != 0L ? Long.valueOf(l3) : null;
                    zzatc2.zzKA();
                    zze2.zzbxB = (int)zzatc2.zzKx();
                    zzatc2.zzY(zze2.zzbxn);
                    zzatc2.zzZ(zze2.zzbxo);
                    zze2.zzbqT = zzatc2.zzKI();
                    this.zzKf().zza(zzatc2);
                }
                if (zze2.zzbxk.length > 0) {
                    this.zzKm().zzLf();
                    zzauv.zzb zzb5 = this.zzKh().zzfL(zza2.zzbuK.zzaS);
                    if (zzb5 == null || zzb5.zzbwR == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzbuK.zzbqP)) {
                            zze2.zzbxI = -1L;
                        } else {
                            this.zzKk().zzLZ().zzj("Did not find measurement config or missing version info. appId", zzatx.zzfE(zza2.zzbuK.zzaS));
                        }
                    } else {
                        zze2.zzbxI = zzb5.zzbwR;
                    }
                    this.zzKf().zza(zze2, bl);
                }
                this.zzKf().zzJ(zza2.zzbuL);
                this.zzKf().zzfB(string2);
                this.zzKf().setTransactionSuccessful();
                boolean bl8 = zze2.zzbxk.length > 0;
                return bl8;
            }
            this.zzKf().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzKf().endTransaction();
        }
    }

    private zzauw.zza[] zza(String string, zzauw.zzg[] zzgArray, zzauw.zzb[] zzbArray) {
        zzac.zzdr((String)string);
        return this.zzJY().zza(string, zzbArray, zzgArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzmR();
        this.zzob();
        zzac.zzdr((String)string);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.zzKf().beginTransaction();
        try {
            boolean bl;
            zzatc zzatc2 = this.zzKf().zzfu(string);
            boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
            if (zzatc2 == null) {
                this.zzKk().zzLZ().zzj("App does not exist in onConfigFetched. appId", zzatx.zzfE(string));
            } else if (bl || n == 404) {
                String string2;
                List<String> list = map != null ? map.get("Last-Modified") : null;
                String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                if (n == 404 || n == 304 ? this.zzKh().zzfL(string) == null && !this.zzKh().zzb(string, null, null) : !this.zzKh().zzb(string, byArray, string2)) {
                    return;
                }
                zzatc2.zzae(this.zznR().currentTimeMillis());
                this.zzKf().zza(zzatc2);
                if (n == 404) {
                    this.zzKk().zzMa().zzj("Config not found. Using empty config. appId", string);
                } else {
                    this.zzKk().zzMd().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                }
                if (this.zzMx().zzqa() && this.zzMG()) {
                    this.zzMF();
                } else {
                    this.zzMH();
                }
            } else {
                boolean bl3;
                zzatc2.zzaf(this.zznR().currentTimeMillis());
                this.zzKf().zza(zzatc2);
                this.zzKk().zzMd().zze("Fetching config failed. code, error", n, throwable);
                this.zzKh().zzfN(string);
                this.zzKl().zzbte.set(this.zznR().currentTimeMillis());
                boolean bl4 = bl3 = n == 503 || n == 429;
                if (bl3) {
                    this.zzKl().zzbtf.set(this.zznR().currentTimeMillis());
                }
                this.zzMH();
            }
            this.zzKf().setTransactionSuccessful();
        }
        finally {
            this.zzKf().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzmR();
        this.zzob();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.zzbuE;
        this.zzbuE = null;
        if ((n == 200 || n == 204) && throwable == null) {
            try {
                this.zzKl().zzbtd.set(this.zznR().currentTimeMillis());
                this.zzKl().zzbte.set(0L);
                this.zzMH();
                this.zzKk().zzMd().zze("Successful upload. Got network response. code, size", n, byArray.length);
                this.zzKf().beginTransaction();
                try {
                    for (Long l : list) {
                        this.zzKf().zzan(l);
                    }
                    this.zzKf().setTransactionSuccessful();
                }
                finally {
                    this.zzKf().endTransaction();
                }
                if (this.zzMx().zzqa() && this.zzMG()) {
                    this.zzMF();
                } else {
                    this.zzbuH = -1L;
                    this.zzMH();
                }
                this.zzbuI = 0L;
            }
            catch (SQLiteException sQLiteException) {
                this.zzKk().zzLX().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                this.zzbuI = this.zznR().elapsedRealtime();
                this.zzKk().zzMd().zzj("Disable upload, time", this.zzbuI);
            }
        } else {
            boolean bl;
            this.zzKk().zzMd().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzKl().zzbte.set(this.zznR().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzKl().zzbtf.set(this.zznR().currentTimeMillis());
            }
            this.zzMH();
        }
    }

    private boolean zzMG() {
        this.zzmR();
        this.zzob();
        boolean bl = this.zzKf().zzLI();
        return bl || !TextUtils.isEmpty((CharSequence)this.zzKf().zzLC());
    }

    @WorkerThread
    private void zzMH() {
        long l;
        long l2;
        this.zzmR();
        this.zzob();
        if (!this.zzML()) {
            return;
        }
        if (this.zzbuI > 0L) {
            l2 = this.zznR().elapsedRealtime();
            l = 3600000L - Math.abs(l2 - this.zzbuI);
            if (l > 0L) {
                this.zzKk().zzMd().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l);
                this.zzMy().unregister();
                this.zzMz().cancel();
                return;
            }
            this.zzbuI = 0L;
        }
        if (!this.zzMs() || !this.zzMG()) {
            this.zzMy().unregister();
            this.zzMz().cancel();
            return;
        }
        l2 = this.zzMI();
        if (l2 == 0L) {
            this.zzMy().unregister();
            this.zzMz().cancel();
            return;
        }
        if (!this.zzMx().zzqa()) {
            this.zzMy().zzpX();
            this.zzMz().cancel();
            return;
        }
        l = this.zzKl().zzbtf.get();
        long l3 = this.zzKm().zzLr();
        if (!this.zzKg().zzh(l, l3)) {
            l2 = Math.max(l2, l + l3);
        }
        this.zzMy().unregister();
        long l4 = l2 - this.zznR().currentTimeMillis();
        if (l4 <= 0L) {
            l4 = this.zzKm().zzLv();
            this.zzKl().zzbtd.set(this.zznR().currentTimeMillis());
        }
        this.zzKk().zzMd().zzj("Upload scheduled in approximately ms", l4);
        this.zzMz().zzy(l4);
    }

    private long zzMI() {
        String string;
        boolean bl;
        long l = this.zznR().currentTimeMillis();
        long l2 = this.zzKm().zzLy();
        boolean bl2 = bl = this.zzKf().zzLJ() || this.zzKf().zzLD();
        long l3 = bl ? (!TextUtils.isEmpty((CharSequence)(string = this.zzKm().zzLB())) && !".none.".equals(string) ? this.zzKm().zzLu() : this.zzKm().zzLt()) : this.zzKm().zzLs();
        long l4 = this.zzKl().zzbtd.get();
        long l5 = this.zzKl().zzbte.get();
        long l6 = this.zzKf().zzLG();
        long l7 = this.zzKf().zzLH();
        long l8 = Math.max(l6, l7);
        if (l8 == 0L) {
            return 0L;
        }
        l8 = l - Math.abs(l8 - l);
        l4 = l - Math.abs(l4 - l);
        l5 = l - Math.abs(l5 - l);
        long l9 = Math.max(l4, l5);
        long l10 = l8 + l2;
        if (bl && l9 > 0L) {
            l10 = Math.min(l8, l9) + l3;
        }
        if (!this.zzKg().zzh(l9, l3)) {
            l10 = l9 + l3;
        }
        if (l5 != 0L && l5 >= l8) {
            long l11 = l10;
            for (int i = 0; i < this.zzKm().zzLA(); ++i) {
                long l12 = 1 << i;
                if ((l11 += this.zzKm().zzLz() * l12) <= l5) continue;
                return l11;
            }
            return 0L;
        }
        return l10;
    }

    public void zzW(boolean bl) {
        this.zzMH();
    }

    void zzb(zzauh zzauh2) {
        ++this.zzbuF;
    }

    void zzMJ() {
        ++this.zzbuG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zze(zzatd zzatd2) {
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatd2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqP)) {
            return;
        }
        if (!zzatd2.zzbqU) {
            this.zzf(zzatd2);
            return;
        }
        long l = this.zznR().currentTimeMillis();
        this.zzKf().beginTransaction();
        try {
            this.zza(zzatd2, l);
            this.zzf(zzatd2);
            zzatn zzatn2 = this.zzKf().zzQ(zzatd2.packageName, "_f");
            if (zzatn2 == null) {
                long l2 = (1L + l / 3600000L) * 3600000L;
                zzauq zzauq2 = new zzauq("_fot", l, l2, "auto");
                this.zzb(zzauq2, zzatd2);
                this.zzb(zzatd2, l);
                this.zzc(zzatd2, l);
            } else if (zzatd2.zzbqV) {
                this.zzd(zzatd2, l);
            }
            this.zzKf().setTransactionSuccessful();
        }
        finally {
            this.zzKf().endTransaction();
        }
    }

    @WorkerThread
    void zza(zzatd zzatd2, long l) {
        zzatc zzatc2 = this.zzKf().zzfu(zzatd2.packageName);
        if (zzatc2 != null && zzatc2.getGmpAppId() != null && !zzatc2.getGmpAppId().equals(zzatd2.zzbqP)) {
            this.zzKk().zzLZ().zzj("New GMP App Id passed in. Removing cached database data. appId", zzatx.zzfE(zzatc2.zzke()));
            this.zzKf().zzfz(zzatc2.zzke());
            zzatc2 = null;
        }
        if (zzatc2 != null && zzatc2.zzmZ() != null && !zzatc2.zzmZ().equals(zzatd2.zzbhM)) {
            Bundle bundle = new Bundle();
            bundle.putString("_pv", zzatc2.zzmZ());
            zzatq zzatq2 = new zzatq("_au", new zzato(bundle), "auto", l);
            this.zzb(zzatq2, zzatd2);
        }
    }

    @WorkerThread
    void zzb(zzatd zzatd2, long l) {
        this.zzmR();
        this.zzob();
        zzatc zzatc2 = this.zzKf().zzfu(zzatd2.packageName);
        if (zzatc2 != null && TextUtils.isEmpty((CharSequence)zzatc2.getGmpAppId()) && zzatd2 != null && !TextUtils.isEmpty((CharSequence)zzatd2.zzbqP)) {
            zzatc2.zzae(0L);
            this.zzKf().zza(zzatc2);
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_c", 1L);
        bundle.putLong("_r", 1L);
        bundle.putLong("_uwa", 0L);
        bundle.putLong("_pfo", 0L);
        bundle.putLong("_sys", 0L);
        bundle.putLong("_sysu", 0L);
        PackageManager packageManager = this.getContext().getPackageManager();
        if (packageManager == null) {
            this.zzKk().zzLX().zzj("PackageManager is null, first open report might be inaccurate. appId", zzatx.zzfE(zzatd2.packageName));
        } else {
            PackageInfo packageInfo = null;
            try {
                packageInfo = zzadg.zzbi((Context)this.getContext()).getPackageInfo(zzatd2.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzKk().zzLX().zze("Package info is null, first open report might be inaccurate. appId", zzatx.zzfE(zzatd2.packageName), (Object)nameNotFoundException);
            }
            if (packageInfo != null && packageInfo.firstInstallTime != 0L && packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                bundle.putLong("_uwa", 1L);
            }
            ApplicationInfo applicationInfo = null;
            try {
                applicationInfo = zzadg.zzbi((Context)this.getContext()).getApplicationInfo(zzatd2.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzKk().zzLX().zze("Application info is null, first open report might be inaccurate. appId", zzatx.zzfE(zzatd2.packageName), (Object)nameNotFoundException);
            }
            if (applicationInfo != null) {
                if ((applicationInfo.flags & 1) != 0) {
                    bundle.putLong("_sys", 1L);
                }
                if ((applicationInfo.flags & 0x80) != 0) {
                    bundle.putLong("_sysu", 1L);
                }
            }
        }
        long l2 = this.zzKf().zzfA(zzatd2.packageName);
        if (l2 >= 0L) {
            bundle.putLong("_pfo", l2);
        }
        zzatq zzatq2 = new zzatq("_f", new zzato(bundle), "auto", l);
        this.zzb(zzatq2, zzatd2);
    }

    @WorkerThread
    void zzc(zzatd zzatd2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_et", 1L);
        zzatq zzatq2 = new zzatq("_e", new zzato(bundle), "auto", l);
        this.zzb(zzatq2, zzatd2);
    }

    @WorkerThread
    void zzd(zzatd zzatd2, long l) {
        Bundle bundle = new Bundle();
        zzatq zzatq2 = new zzatq("_cd", new zzato(bundle), "auto", l);
        this.zzb(zzatq2, zzatd2);
    }

    @WorkerThread
    private void zzf(zzatd zzatd2) {
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatd2.packageName);
        zzatc zzatc2 = this.zzKf().zzfu(zzatd2.packageName);
        String string = this.zzKl().zzfH(zzatd2.packageName);
        boolean bl = false;
        if (zzatc2 == null) {
            zzatc2 = new zzatc(this, zzatd2.packageName);
            zzatc2.zzfd(this.zzKl().zzMg());
            zzatc2.zzff(string);
            bl = true;
        } else if (!string.equals(zzatc2.zzKo())) {
            zzatc2.zzff(string);
            zzatc2.zzfd(this.zzKl().zzMg());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzatd2.zzbqP) && !zzatd2.zzbqP.equals(zzatc2.getGmpAppId())) {
            zzatc2.zzfe(zzatd2.zzbqP);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzatd2.zzbqX) && !zzatd2.zzbqX.equals(zzatc2.zzKp())) {
            zzatc2.zzfg(zzatd2.zzbqX);
            bl = true;
        }
        if (zzatd2.zzbqR != 0L && zzatd2.zzbqR != zzatc2.zzKu()) {
            zzatc2.zzab(zzatd2.zzbqR);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzatd2.zzbhM) && !zzatd2.zzbhM.equals(zzatc2.zzmZ())) {
            zzatc2.setAppVersion(zzatd2.zzbhM);
            bl = true;
        }
        if (zzatd2.zzbqW != zzatc2.zzKs()) {
            zzatc2.zzaa(zzatd2.zzbqW);
            bl = true;
        }
        if (zzatd2.zzbqQ != null && !zzatd2.zzbqQ.equals(zzatc2.zzKt())) {
            zzatc2.zzfh(zzatd2.zzbqQ);
            bl = true;
        }
        if (zzatd2.zzbqS != zzatc2.zzKv()) {
            zzatc2.zzac(zzatd2.zzbqS);
            bl = true;
        }
        if (zzatd2.zzbqU != zzatc2.zzKw()) {
            zzatc2.setMeasurementEnabled(zzatd2.zzbqU);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzatd2.zzbqT) && !zzatd2.zzbqT.equals(zzatc2.zzKH())) {
            zzatc2.zzfi(zzatd2.zzbqT);
            bl = true;
        }
        if (zzatd2.zzbqY != zzatc2.zzuW()) {
            zzatc2.zzam(zzatd2.zzbqY);
            bl = true;
        }
        if (bl) {
            this.zzKf().zza(zzatc2);
        }
    }

    @WorkerThread
    void zzMK() {
        this.zzmR();
        this.zzob();
        if (!this.zzbuz) {
            this.zzKk().zzMb().log("This instance being marked as an uploader");
            this.zzMB();
        }
        this.zzbuz = true;
    }

    @WorkerThread
    boolean zzML() {
        this.zzmR();
        this.zzob();
        return this.zzbuz;
    }

    private class zza
    implements zzatj.zzb {
        zzauw.zze zzbuK;
        List<Long> zzbuL;
        List<zzauw.zzb> zzth;
        long zzbuM;

        private zza() {
        }

        @Override
        public void zzb(zzauw.zze zze2) {
            zzac.zzw((Object)((Object)zze2));
            this.zzbuK = zze2;
        }

        @Override
        public boolean zza(long l, zzauw.zzb zzb2) {
            zzac.zzw((Object)((Object)zzb2));
            if (this.zzth == null) {
                this.zzth = new ArrayList<zzauw.zzb>();
            }
            if (this.zzbuL == null) {
                this.zzbuL = new ArrayList<Long>();
            }
            if (this.zzth.size() > 0 && this.zza(this.zzth.get(0)) != this.zza(zzb2)) {
                return false;
            }
            long l2 = this.zzbuM + (long)zzb2.zzaeS();
            if (l2 >= (long)zzaue.this.zzKm().zzLm()) {
                return false;
            }
            this.zzbuM = l2;
            this.zzth.add(zzb2);
            this.zzbuL.add(l);
            return this.zzth.size() < zzaue.this.zzKm().zzLn();
        }

        private long zza(zzauw.zzb zzb2) {
            return zzb2.zzbxd / 1000L / 60L / 60L;
        }

        boolean isEmpty() {
            return this.zzth == null || this.zzth.isEmpty();
        }
    }
}

