/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class zzauk
extends zzauh {
    protected zza zzbvq;
    private volatile AppMeasurement.zzf zzbvr;
    private AppMeasurement.zzf zzbvs;
    private long zzbvt;
    private final Map<Activity, zza> zzbvu = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zzd> zzbvv = new CopyOnWriteArrayList();
    private boolean zzbvw;
    private AppMeasurement.zzf zzbvx;
    private String zzbvy;

    public zzauk(zzaue zzaue2) {
        super(zzaue2);
    }

    @Override
    protected void zzmS() {
    }

    @WorkerThread
    public zza zzMT() {
        this.zzob();
        this.zzmR();
        return this.zzbvq;
    }

    @MainThread
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        boolean bl;
        if (activity == null) {
            this.zzKk().zzLZ().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        if (!this.zzKj().zzbc()) {
            this.zzKk().zzLZ().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzbvw) {
            this.zzKk().zzLZ().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzbvr == null) {
            this.zzKk().zzLZ().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzbvu.get(activity) == null) {
            this.zzKk().zzLZ().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzauk.zzfS(activity.getClass().getCanonicalName());
        }
        boolean bl2 = this.zzbvr.zzbqk.equals(string2);
        boolean bl3 = bl = this.zzbvr.zzbqj == null && string == null || this.zzbvr.zzbqj != null && this.zzbvr.zzbqj.equals(string);
        if (bl2 && bl) {
            this.zzKk().zzMa().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() < 1 || string.length() > this.zzKm().zzKO())) {
            this.zzKk().zzLZ().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() < 1 || string2.length() > this.zzKm().zzKO())) {
            this.zzKk().zzLZ().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        this.zzKk().zzMd().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zza zza2 = new zza(string, string2, this.zzKg().zzNh());
        this.zzbvu.put(activity, zza2);
        this.zza(activity, zza2, true);
    }

    public AppMeasurement.zzf zzMU() {
        this.zzJV();
        AppMeasurement.zzf zzf2 = this.zzbvr;
        if (zzf2 == null) {
            return null;
        }
        return new AppMeasurement.zzf(zzf2);
    }

    @MainThread
    public void registerOnScreenChangeCallback(@NonNull AppMeasurement.zzd zzd2) {
        this.zzJV();
        if (zzd2 == null) {
            this.zzKk().zzLZ().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzbvv.remove(zzd2);
        this.zzbvv.add(zzd2);
    }

    @MainThread
    public void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zzd zzd2) {
        this.zzJV();
        this.zzbvv.remove(zzd2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    private void zza(Activity activity, zza zza2, final boolean bl) {
        AppMeasurement.zzf zzf2 = null;
        if (this.zzbvr != null) {
            zzf2 = this.zzbvr;
        } else if (this.zzbvs != null && Math.abs(this.zznR().elapsedRealtime() - this.zzbvt) < 1000L) {
            zzf2 = this.zzbvs;
        }
        AppMeasurement.zzf zzf3 = null;
        if (zzf2 != null) {
            zzf3 = new AppMeasurement.zzf(zzf2);
        }
        boolean bl2 = true;
        this.zzbvw = true;
        try {
            for (AppMeasurement.zzd zzd2 : this.zzbvv) {
                try {
                    bl2 &= zzd2.zza(zzf3, zza2);
                }
                catch (Exception exception) {
                    this.zzKk().zzLX().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            this.zzKk().zzLX().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzbvw = false;
        }
        if (bl2) {
            if (zza2.zzbqk == null) {
                zza2.zzbqk = zzauk.zzfS(activity.getClass().getCanonicalName());
            }
            final zza zza3 = new zza(zza2);
            this.zzbvs = this.zzbvr;
            this.zzbvt = this.zznR().elapsedRealtime();
            this.zzbvr = zza3;
            this.zzKj().zzm(new Runnable(){

                @Override
                public void run() {
                    if (bl && zzauk.this.zzbvq != null) {
                        zzauk.this.zza(zzauk.this.zzbvq);
                    }
                    zzauk.this.zzbvq = zza3;
                    zzauk.this.zzKc().zza(zza3);
                }
            });
        }
    }

    @WorkerThread
    private void zza(@NonNull zza zza2) {
        this.zzJX().zzW(this.zznR().elapsedRealtime());
        if (this.zzKi().zzaO(zza2.zzbvD)) {
            zza2.zzbvD = false;
        }
    }

    public static void zza(AppMeasurement.zzf zzf2, Bundle bundle) {
        if (bundle != null && zzf2 != null && !bundle.containsKey("_sc")) {
            if (zzf2.zzbqj != null) {
                bundle.putString("_sn", zzf2.zzbqj);
            }
            bundle.putString("_sc", zzf2.zzbqk);
            bundle.putLong("_si", zzf2.zzbql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(String string, AppMeasurement.zzf zzf2) {
        this.zzmR();
        zzauk zzauk2 = this;
        synchronized (zzauk2) {
            if (this.zzbvy == null || this.zzbvy.equals(string) || zzf2 != null) {
                this.zzbvy = string;
                this.zzbvx = zzf2;
            }
        }
    }

    static String zzfS(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    zza zzv(@NonNull Activity activity) {
        zzac.zzw((Object)activity);
        zza zza2 = this.zzbvu.get(activity);
        if (zza2 == null) {
            String string = zzauk.zzfS(activity.getClass().getCanonicalName());
            zza2 = new zza(null, string, this.zzKg().zzNh());
            this.zzbvu.put(activity, zza2);
        }
        return zza2;
    }

    @MainThread
    public void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.firebase.analytics.screen_service");
        if (bundle2 == null) {
            return;
        }
        zza zza2 = this.zzv(activity);
        zza2.zzbql = bundle2.getLong("id");
        zza2.zzbqj = bundle2.getString("name");
        zza2.zzbqk = bundle2.getString("referrer_name");
    }

    @MainThread
    public void onActivityResumed(Activity activity) {
        zza zza2 = this.zzv(activity);
        this.zza(activity, zza2, false);
        this.zzJX().zzJT();
    }

    @MainThread
    public void onActivityPaused(Activity activity) {
        final zza zza2 = this.zzv(activity);
        this.zzbvs = this.zzbvr;
        this.zzbvt = this.zznR().elapsedRealtime();
        this.zzbvr = null;
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzauk.this.zza(zza2);
                zzauk.this.zzbvq = null;
                zzauk.this.zzKc().zza((AppMeasurement.zzf)null);
            }
        });
    }

    @MainThread
    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zza zza2 = this.zzbvu.get(activity);
        if (zza2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zza2.zzbql);
        bundle2.putString("name", zza2.zzbqj);
        bundle2.putString("referrer_name", zza2.zzbqk);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public void onActivityDestroyed(Activity activity) {
        this.zzbvu.remove(activity);
    }

    static class zza
    extends AppMeasurement.zzf {
        public boolean zzbvD;

        public zza(String string, String string2, long l) {
            this.zzbqj = string;
            this.zzbqk = string2;
            this.zzbql = l;
            this.zzbvD = false;
        }

        public zza(zza zza2) {
            this.zzbqj = zza2.zzbqj;
            this.zzbqk = zza2.zzbqk;
            this.zzbql = zza2.zzbql;
            this.zzbvD = zza2.zzbvD;
        }
    }
}

