/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzaug;
import com.google.android.gms.internal.zzauk;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public class zzatb
extends zzaug {
    private final Map<String, Long> zzbql;
    private final Map<String, Integer> zzbqm = new ArrayMap();
    private long zzbqn;

    public zzatb(zzaue zzaue2) {
        super(zzaue2);
        this.zzbql = new ArrayMap();
    }

    public void beginAdUnitExposure(final String string) {
        if (string == null || string.length() == 0) {
            this.zzKl().zzLY().log("Ad unit id must be a non-empty string");
            return;
        }
        final long l = this.zznR().elapsedRealtime();
        this.zzKk().zzm(new Runnable(){

            @Override
            public void run() {
                zzatb.this.zzf(string, l);
            }
        });
    }

    @WorkerThread
    private void zzf(String string, long l) {
        Integer n;
        this.zzJW();
        this.zzmR();
        zzac.zzdr((String)string);
        if (this.zzbqm.isEmpty()) {
            this.zzbqn = l;
        }
        if ((n = this.zzbqm.get(string)) != null) {
            this.zzbqm.put(string, n + 1);
        } else {
            if (this.zzbqm.size() >= 100) {
                this.zzKl().zzMa().log("Too many ads visible");
                return;
            }
            this.zzbqm.put(string, 1);
            this.zzbql.put(string, l);
        }
    }

    public void endAdUnitExposure(final String string) {
        if (string == null || string.length() == 0) {
            this.zzKl().zzLY().log("Ad unit id must be a non-empty string");
            return;
        }
        final long l = this.zznR().elapsedRealtime();
        this.zzKk().zzm(new Runnable(){

            @Override
            public void run() {
                zzatb.this.zzg(string, l);
            }
        });
    }

    @WorkerThread
    private void zzg(String string, long l) {
        this.zzJW();
        this.zzmR();
        zzac.zzdr((String)string);
        Integer n = this.zzbqm.get(string);
        if (n != null) {
            zzauk.zza zza2 = this.zzKe().zzMU();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzbqm.remove(string);
                Long l2 = this.zzbql.get(string);
                if (l2 == null) {
                    this.zzKl().zzLY().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzbql.remove(string);
                    this.zza(string, l3, zza2);
                }
                if (this.zzbqm.isEmpty()) {
                    if (this.zzbqn == 0L) {
                        this.zzKl().zzLY().log("First ad exposure time was never set");
                    } else {
                        this.zza(l - this.zzbqn, zza2);
                        this.zzbqn = 0L;
                    }
                }
            } else {
                this.zzbqm.put(string, n2);
            }
        } else {
            this.zzKl().zzLY().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
        }
    }

    @WorkerThread
    private void zza(long l, AppMeasurement.zzf zzf2) {
        if (zzf2 == null) {
            this.zzKl().zzMe().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzKl().zzMe().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzauk.zza(zzf2, bundle);
        this.zzKa().zze("am", "_xa", bundle);
    }

    @WorkerThread
    private void zza(String string, long l, AppMeasurement.zzf zzf2) {
        if (zzf2 == null) {
            this.zzKl().zzMe().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzKl().zzMe().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzauk.zza(zzf2, bundle);
        this.zzKa().zze("am", "_xu", bundle);
    }

    @WorkerThread
    public void zzW(long l) {
        zzauk.zza zza2 = this.zzKe().zzMU();
        for (String string : this.zzbql.keySet()) {
            long l2 = this.zzbql.get(string);
            this.zza(string, l - l2, zza2);
        }
        if (!this.zzbql.isEmpty()) {
            this.zza(l - this.zzbqn, zza2);
        }
        this.zzX(l);
    }

    public void zzJU() {
        final long l = this.zznR().elapsedRealtime();
        this.zzKk().zzm(new Runnable(){

            @Override
            public void run() {
                zzatb.this.zzX(l);
            }
        });
    }

    @WorkerThread
    private void zzX(long l) {
        for (String string : this.zzbql.keySet()) {
            this.zzbql.put(string, l);
        }
        if (!this.zzbql.isEmpty()) {
            this.zzbqn = l;
        }
    }
}

