/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauf;
import com.google.android.gms.internal.zzaut;

public final class zzaum {
    private final Handler mHandler;
    private final Context mContext;
    private final zza zzbvT;

    public zzaum(zza zza2) {
        this.mContext = zza2.getContext();
        zzac.zzw((Object)this.mContext);
        this.zzbvT = zza2;
        this.mHandler = new Handler();
    }

    public static boolean zzj(Context context, boolean bl) {
        zzac.zzw((Object)context);
        return zzaut.zzy(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public void onCreate() {
        zzaue zzaue2 = zzaue.zzbM(this.mContext);
        zzatx zzatx2 = zzaue2.zzKl();
        zzaue2.zzKn().zzLg();
        zzatx2.zzMe().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public void onDestroy() {
        zzaue zzaue2 = zzaue.zzbM(this.mContext);
        zzatx zzatx2 = zzaue2.zzKl();
        zzaue2.zzKn().zzLg();
        zzatx2.zzMe().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public int onStartCommand(Intent intent, int n, final int n2) {
        final zzaue zzaue2 = zzaue.zzbM(this.mContext);
        final zzatx zzatx2 = zzaue2.zzKl();
        if (intent == null) {
            zzatx2.zzMa().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzaue2.zzKn().zzLg();
        zzatx2.zzMe().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzaue2.zzKk().zzm(new Runnable(){

                @Override
                public void run() {
                    zzaue2.zzML();
                    zzaue2.zzMG();
                    zzaum.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = zzaum.this.zzbvT.callServiceStopSelfResult(n2);
                            if (bl) {
                                zzaue2.zzKn().zzLg();
                                zzatx2.zzMe().log("Local AppMeasurementService processed last upload request");
                            }
                        }
                    });
                }
            });
        }
        return 2;
    }

    @MainThread
    public IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzKl().zzLY().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzauf(zzaue.zzbM(this.mContext));
        }
        this.zzKl().zzMa().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzKl().zzLY().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzKl().zzMe().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    public void onRebind(Intent intent) {
        if (intent == null) {
            this.zzKl().zzLY().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzKl().zzMe().zzj("onRebind called. action", string);
    }

    private zzatx zzKl() {
        return zzaue.zzbM(this.mContext).zzKl();
    }

    public static interface zza {
        public boolean callServiceStopSelfResult(int var1);

        public Context getContext();
    }
}

